/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.interceptor;

import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti5.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.interceptor.AbstractCommandInterceptor;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandConfig;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.interceptor.CommandContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContextInterceptor
extends AbstractCommandInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CommandContextInterceptor.class);
    protected CommandContextFactory commandContextFactory;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public CommandContextInterceptor() {
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.commandContextFactory = commandContextFactory;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext context = Context.getCommandContext();
        boolean contextReused = false;
        if (!config.isContextReusePossible() || context == null || context.getException() != null) {
            context = this.commandContextFactory.createCommandContext(command);
        } else {
            log.debug("Valid context found. Reusing it for the current command '{}'", (Object)command.getClass().getCanonicalName());
            contextReused = true;
        }
        try {
            Context.setCommandContext(context);
            Context.setProcessEngineConfiguration(this.processEngineConfiguration);
            org.activiti.engine.impl.context.Context.setFallbackActiviti5CompatibilityHandler((Activiti5CompatibilityHandler)this.processEngineConfiguration.getActiviti5CompatibilityHandler());
            T t = this.next.execute(config, command);
            return t;
        }
        catch (Exception e) {
            context.exception(e);
        }
        finally {
            try {
                if (!contextReused) {
                    context.close();
                }
            }
            finally {
                Context.removeCommandContext();
                Context.removeProcessEngineConfiguration();
                Context.removeBpmnOverrideContext();
            }
        }
        return null;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineContext(ProcessEngineConfigurationImpl processEngineContext) {
        this.processEngineConfiguration = processEngineContext;
    }
}

