/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.juel;

import java.io.PrintWriter;
import java.util.EnumSet;
import org.activiti5.engine.impl.javax.el.ELContext;
import org.activiti5.engine.impl.javax.el.ELException;
import org.activiti5.engine.impl.javax.el.ELResolver;
import org.activiti5.engine.impl.javax.el.FunctionMapper;
import org.activiti5.engine.impl.javax.el.VariableMapper;
import org.activiti5.engine.impl.juel.Bindings;
import org.activiti5.engine.impl.juel.NodePrinter;
import org.activiti5.engine.impl.juel.Parser;
import org.activiti5.engine.impl.juel.Scanner;
import org.activiti5.engine.impl.juel.Tree;
import org.activiti5.engine.impl.juel.TreeBuilder;
import org.activiti5.engine.impl.juel.TreeBuilderException;

public class Builder
implements TreeBuilder {
    private static final long serialVersionUID = 1L;
    protected final EnumSet<Feature> features;

    public Builder() {
        this.features = EnumSet.noneOf(Feature.class);
    }

    public Builder(Feature ... features) {
        if (features == null || features.length == 0) {
            this.features = EnumSet.noneOf(Feature.class);
        } else if (features.length == 1) {
            this.features = EnumSet.of(features[0]);
        } else {
            Feature[] rest = new Feature[features.length - 1];
            for (int i = 1; i < features.length; ++i) {
                rest[i - 1] = features[i];
            }
            this.features = EnumSet.of(features[0], rest);
        }
    }

    public boolean isEnabled(Feature feature) {
        return this.features.contains((Object)feature);
    }

    @Override
    public Tree build(String expression) throws TreeBuilderException {
        try {
            return this.createParser(expression).tree();
        }
        catch (Scanner.ScanException e) {
            throw new TreeBuilderException(expression, e.position, e.encountered, e.expected, e.getMessage());
        }
        catch (Parser.ParseException e) {
            throw new TreeBuilderException(expression, e.position, e.encountered, e.expected, e.getMessage());
        }
    }

    protected Parser createParser(String expression) {
        return new Parser(this, expression);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.features.equals(((Builder)obj).features);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: java " + Builder.class.getName() + " <expression string>");
            System.exit(1);
        }
        PrintWriter out = new PrintWriter(System.out);
        Tree tree = null;
        try {
            tree = new Builder(Feature.METHOD_INVOCATIONS).build(args[0]);
        }
        catch (TreeBuilderException e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
        NodePrinter.dump(out, tree.getRoot());
        if (!tree.getFunctionNodes().iterator().hasNext() && !tree.getIdentifierNodes().iterator().hasNext()) {
            ELContext context = new ELContext(){

                @Override
                public VariableMapper getVariableMapper() {
                    return null;
                }

                @Override
                public FunctionMapper getFunctionMapper() {
                    return null;
                }

                @Override
                public ELResolver getELResolver() {
                    return null;
                }
            };
            out.print(">> ");
            try {
                out.println(tree.getRoot().getValue(new Bindings(null, null), context, null));
            }
            catch (ELException e) {
                out.println(e.getMessage());
            }
        }
        out.flush();
    }

    public static enum Feature {
        METHOD_INVOCATIONS,
        NULL_PROPERTIES,
        VARARGS;

    }
}

