/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.util.HashMap;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.persistence.AbstractManager;
import org.activiti5.engine.impl.persistence.entity.MembershipEntity;
import org.activiti5.engine.impl.persistence.entity.MembershipIdentityManager;

public class MembershipEntityManager
extends AbstractManager
implements MembershipIdentityManager {
    @Override
    public void createMembership(String userId, String groupId) {
        MembershipEntity membershipEntity = new MembershipEntity();
        membershipEntity.setUserId(userId);
        membershipEntity.setGroupId(groupId);
        this.getDbSqlSession().insert(membershipEntity);
        if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createMembershipEvent(ActivitiEventType.MEMBERSHIP_CREATED, groupId, userId));
        }
    }

    @Override
    public void deleteMembership(String userId, String groupId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        this.getDbSqlSession().delete("deleteMembership", parameters);
        if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createMembershipEvent(ActivitiEventType.MEMBERSHIP_DELETED, groupId, userId));
        }
    }
}

