/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.compatibility.spring;

import org.activiti.compatibility.spring.DefaultActiviti5SpringCompatibilityHandler;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringActiviti5CompatibilityHandlerFactory
implements Activiti5CompatibilityHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringActiviti5CompatibilityHandlerFactory.class);
    protected String compatibilityHandlerClassName;

    public Activiti5CompatibilityHandler createActiviti5CompatibilityHandler() {
        if (this.compatibilityHandlerClassName != null) {
            try {
                Activiti5CompatibilityHandler handler = (Activiti5CompatibilityHandler)Class.forName(this.compatibilityHandlerClassName).newInstance();
                return handler;
            }
            catch (Exception e) {
                logger.info("Activiti 5 compatibility handler implementation not found or error during instantiation : " + e.getMessage() + ". Activiti 5 backwards compatibility disabled.");
            }
        } else {
            return new DefaultActiviti5SpringCompatibilityHandler();
        }
        return null;
    }

    public String getCompatibilityHandlerClassName() {
        return this.compatibilityHandlerClassName;
    }

    public void setCompatibilityHandlerClassName(String compatibilityHandlerClassName) {
        this.compatibilityHandlerClassName = compatibilityHandlerClassName;
    }
}

