/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.spring;

import java.util.Map;
import org.activiti5.engine.ProcessEngine;
import org.activiti5.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti5.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.activiti5.engine.impl.el.ExpressionManager;
import org.activiti5.spring.SpringExpressionManager;
import org.activiti5.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ProcessEngineFactoryBean
implements FactoryBean<ProcessEngine>,
DisposableBean,
ApplicationContextAware {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected ProcessEngine processEngine;

    public void destroy() throws Exception {
        if (this.processEngine != null) {
            this.processEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ProcessEngine getObject() throws Exception {
        this.configureExpressionManager();
        this.configureExternallyManagedTransactions();
        if (this.processEngineConfiguration.getBeans() == null) {
            this.processEngineConfiguration.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext));
        }
        this.processEngine = this.processEngineConfiguration.buildProcessEngine();
        return this.processEngine;
    }

    protected void configureExpressionManager() {
        if (this.processEngineConfiguration.getExpressionManager() == null && this.applicationContext != null) {
            this.processEngineConfiguration.setExpressionManager((ExpressionManager)new SpringExpressionManager(this.applicationContext, this.processEngineConfiguration.getBeans()));
        }
    }

    protected void configureExternallyManagedTransactions() {
        SpringProcessEngineConfiguration engineConfiguration;
        if (this.processEngineConfiguration instanceof SpringProcessEngineConfiguration && (engineConfiguration = (SpringProcessEngineConfiguration)this.processEngineConfiguration).getTransactionManager() != null) {
            this.processEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<ProcessEngine> getObjectType() {
        return ProcessEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }
}

