/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.spring.autodeployment;

import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.RepositoryService;
import org.activiti5.engine.repository.DeploymentBuilder;
import org.activiti5.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public class DefaultAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "default";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, RepositoryService repositoryService) {
        DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentNameHint);
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            try {
                if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip") || resourceName.endsWith(".jar")) {
                    deploymentBuilder.addZipInputStream(new ZipInputStream(resource.getInputStream()));
                    continue;
                }
                deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
            }
            catch (IOException e) {
                throw new ActivitiException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
            }
        }
        deploymentBuilder.deploy();
    }
}

