/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.api.model.converter;

import java.util.List;
import org.activiti.cloud.services.api.model.ProcessInstance;
import org.activiti.cloud.services.api.model.converter.ListConverter;
import org.activiti.cloud.services.api.model.converter.ModelConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceConverter
implements ModelConverter<org.activiti.engine.runtime.ProcessInstance, ProcessInstance> {
    private final ListConverter listConverter;

    @Autowired
    public ProcessInstanceConverter(ListConverter listConverter) {
        this.listConverter = listConverter;
    }

    @Override
    public ProcessInstance from(org.activiti.engine.runtime.ProcessInstance source) {
        ProcessInstance processInstance = null;
        if (source != null) {
            processInstance = new ProcessInstance(source.getId(), source.getName(), source.getDescription(), source.getProcessDefinitionId(), source.getStartUserId(), source.getStartTime(), source.getBusinessKey(), this.calculateStatus(source), source.getProcessDefinitionKey());
        }
        return processInstance;
    }

    private String calculateStatus(org.activiti.engine.runtime.ProcessInstance source) {
        if (source.isSuspended()) {
            return ProcessInstance.ProcessInstanceStatus.SUSPENDED.name();
        }
        if (source.isEnded()) {
            return ProcessInstance.ProcessInstanceStatus.COMPLETED.name();
        }
        return ProcessInstance.ProcessInstanceStatus.RUNNING.name();
    }

    @Override
    public List<ProcessInstance> from(List<org.activiti.engine.runtime.ProcessInstance> processInstances) {
        return this.listConverter.from(processInstances, this);
    }
}

