/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.api.model.converter;

import java.util.List;
import org.activiti.cloud.services.api.model.Task;
import org.activiti.cloud.services.api.model.converter.ListConverter;
import org.activiti.cloud.services.api.model.converter.ModelConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskConverter
implements ModelConverter<org.activiti.engine.task.Task, Task> {
    private final ListConverter listConverter;

    @Autowired
    public TaskConverter(ListConverter listConverter) {
        this.listConverter = listConverter;
    }

    @Override
    public Task from(org.activiti.engine.task.Task source) {
        Task task = null;
        if (source != null) {
            task = new Task(source.getId(), source.getOwner(), source.getAssignee(), source.getName(), source.getDescription(), source.getCreateTime(), source.getClaimTime(), source.getDueDate(), source.getPriority(), source.getProcessDefinitionId(), source.getProcessInstanceId(), source.getParentTaskId(), this.calculateStatus(source));
        }
        return task;
    }

    private String calculateStatus(org.activiti.engine.task.Task source) {
        if (source.isSuspended()) {
            return Task.TaskStatus.SUSPENDED.name();
        }
        if (source.getAssignee() != null && !source.getAssignee().isEmpty()) {
            return Task.TaskStatus.ASSIGNED.name();
        }
        return Task.TaskStatus.CREATED.name();
    }

    @Override
    public List<Task> from(List<org.activiti.engine.task.Task> tasks) {
        return this.listConverter.from(tasks, this);
    }
}

