/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.content.storage.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.activiti.content.storage.api.ContentObject;
import org.activiti.content.storage.exception.ContentStorageException;

public class FileSystemContentObject
implements ContentObject {
    private File file;
    private InputStream inputStream;
    private String id;
    private Long length;

    public FileSystemContentObject(File file, String id, Long length) {
        this.file = file;
        this.id = id;
        this.length = length;
    }

    public String getId() {
        return this.id;
    }

    public long getContentLength() {
        if (this.length == null) {
            this.length = this.file.length();
        }
        return this.length;
    }

    public InputStream getContent() {
        if (this.inputStream == null) {
            try {
                this.inputStream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ContentStorageException("Error while opening file stream", (Throwable)e);
            }
        }
        return this.inputStream;
    }
}

