/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.content.storage.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.activiti.content.storage.api.ContentObject;
import org.activiti.content.storage.api.ContentStorage;
import org.activiti.content.storage.exception.ContentNotFoundException;
import org.activiti.content.storage.exception.ContentStorageException;
import org.activiti.content.storage.fs.FileSystemContentObject;
import org.activiti.content.storage.fs.PathConverter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemContentStorage
implements ContentStorage {
    private static final String TEMP_SUFFIX = "_TEMP";
    private static final String OLD_SUFFIX = "_OLD";
    private File rootFolder;
    private File currentLeafFolder;
    private PathConverter converter;
    private Object idLock = new Object();
    private int currentIndex = 0;
    private static final Logger logger = LoggerFactory.getLogger(FileSystemContentStorage.class);
    private static final int MAX_FOLDER_RETRIES = 50;

    public FileSystemContentStorage(File contentFolderRoot, int blockSize, int depth) {
        this.rootFolder = contentFolderRoot;
        this.converter = new PathConverter();
        this.converter.setBlockSize(blockSize);
        this.converter.setIterationDepth(depth);
    }

    public ContentObject createContentObject(InputStream contentStream, Long lengthHint) {
        BigInteger id = this.fetchNewId();
        File contentFile = new File(this.rootFolder, this.converter.getPathForId(id).getPath());
        long length = -1L;
        try {
            length = IOUtils.copy((InputStream)contentStream, (OutputStream)new FileOutputStream(contentFile, false));
        }
        catch (FileNotFoundException e) {
            throw new ContentStorageException("Content file was deleted or no longer accessible prior to writing: " + contentFile, (Throwable)e);
        }
        catch (IOException e) {
            throw new ContentStorageException("Error while writing content to file: " + contentFile, (Throwable)e);
        }
        if (length < 0L) {
            length = contentFile.length();
        }
        return new FileSystemContentObject(contentFile, id.toString(), length);
    }

    public ContentObject getContentObject(String id) {
        File contentFile = this.getFileForId(id, true);
        return new FileSystemContentObject(contentFile, id, null);
    }

    public ContentObject updateContentObject(String id, InputStream contentStream, Long lengthHint) {
        long length;
        File contentFile;
        block13: {
            contentFile = this.getFileForId(id, true);
            File tempContentFile = new File(contentFile.getParentFile(), id + TEMP_SUFFIX);
            File oldContentFile = new File(contentFile.getParentFile(), id + OLD_SUFFIX);
            boolean tempFileCreated = false;
            length = -1L;
            try {
                if (!tempContentFile.createNewFile()) {
                    throw new ContentStorageException("Cannot update content with id: " + id + ", being updated by another user");
                }
                tempFileCreated = true;
                FileOutputStream tempOutputStream = new FileOutputStream(tempContentFile);
                length = IOUtils.copy((InputStream)contentStream, (OutputStream)tempOutputStream);
                IOUtils.closeQuietly((OutputStream)tempOutputStream);
                if (contentFile.renameTo(oldContentFile)) {
                    if (tempContentFile.renameTo(contentFile)) {
                        oldContentFile.delete();
                        break block13;
                    }
                    oldContentFile.renameTo(contentFile);
                    throw new ContentStorageException("Error while renaming new content file, content not updated");
                }
                throw new ContentStorageException("Error while renaming existing content file, content not updated");
            }
            catch (IOException ioe) {
                throw new ContentStorageException("Error while updating content with id: " + id, (Throwable)ioe);
            }
            finally {
                if (tempFileCreated) {
                    try {
                        tempContentFile.delete();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return new FileSystemContentObject(contentFile, id.toString(), length);
    }

    public void deleteContentObject(String id) {
        try {
            File contentFile = this.getFileForId(id, true);
            contentFile.delete();
        }
        catch (Exception e) {
            throw new ContentStorageException("Error while deleting content", (Throwable)e);
        }
    }

    protected File getFileForId(String id, boolean shouldExist) {
        BigInteger idValue = null;
        try {
            idValue = new BigInteger(id);
        }
        catch (NumberFormatException nfe) {
            throw new ContentStorageException("Illegal ID value, only positive numbers are supported: " + id, (Throwable)nfe);
        }
        File path = this.converter.getPathForId(idValue);
        File file = new File(this.rootFolder, path.getPath());
        if (shouldExist != file.exists()) {
            if (shouldExist) {
                throw new ContentNotFoundException("Content with id: " + id + " was not found (path: " + file.toString() + ")");
            }
            throw new ContentNotFoundException("Content with id: " + id + " already exists.");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BigInteger fetchNewId() {
        int indexToUse;
        if (this.currentLeafFolder == null) {
            this.currentLeafFolder = this.getFirstAvailableFolder(50);
        }
        File leafToUse = null;
        Object object = this.idLock;
        synchronized (object) {
            ++this.currentIndex;
            if (this.currentIndex >= this.converter.getBlockSize()) {
                this.currentLeafFolder = this.getFirstAvailableFolder(50);
                indexToUse = 0;
                this.currentIndex = 0;
            } else {
                indexToUse = this.currentIndex;
            }
            leafToUse = this.currentLeafFolder;
        }
        File contentFile = new File(leafToUse, indexToUse + "");
        if (contentFile.exists()) {
            throw new ContentStorageException("Content already stored at that location, shouldn't have happended: " + contentFile);
        }
        try {
            if (!contentFile.createNewFile()) {
                throw new ContentStorageException("Unable to create content file: " + contentFile);
            }
        }
        catch (IOException ioe) {
            throw new ContentStorageException("Error while creating content file: " + contentFile, (Throwable)ioe);
        }
        return this.converter.getIdForPath(contentFile);
    }

    protected File getFirstAvailableFolder(int maxRetries) {
        if (maxRetries == 0) {
            logger.error("Giving up looking for next available folder, no more retries left");
            throw new ContentStorageException("Took too many attempts to get an available free folder");
        }
        File currentMaxFolder = this.rootFolder;
        File child = null;
        int[] indexes = new int[this.converter.getIterationDepth() - 1];
        boolean created = false;
        for (int i = 0; i < this.converter.getIterationDepth() - 1; ++i) {
            created = false;
            child = this.getMaxChild(currentMaxFolder);
            if (child == null) {
                child = new File(currentMaxFolder, "0");
                child.mkdir();
                created = true;
            }
            indexes[i] = Integer.parseInt(child.getName());
            currentMaxFolder = child;
        }
        if (created) {
            return currentMaxFolder;
        }
        int lastIndex = indexes[this.converter.getIterationDepth() - 2];
        if (lastIndex >= this.converter.getBlockSize() - 1) {
            logger.debug("Block size reached, moving up one level: " + currentMaxFolder.getAbsolutePath());
            boolean needsMove = false;
            for (int i = this.converter.getIterationDepth() - 2; i >= 0; --i) {
                int value = indexes[i] + 1;
                if (value <= this.converter.getBlockSize() - 1) {
                    indexes[i] = value;
                    needsMove = false;
                    break;
                }
                indexes[i] = value = 0;
                needsMove = true;
            }
            if (needsMove) {
                logger.error("Maximum number of content items reached, cannot store any more content: " + currentMaxFolder.getAbsolutePath());
                throw new ContentStorageException("Maximum number of content items reached, cannot store any more content");
            }
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < indexes.length; ++i) {
                buffer.append(indexes[i] + "").append(File.separatorChar);
            }
            File newFolder = new File(this.rootFolder, buffer.toString());
            if (newFolder.mkdirs()) {
                return newFolder;
            }
            logger.debug("Next folder already created, retrying...");
            return this.getFirstAvailableFolder(--maxRetries);
        }
        File newFolder = new File(currentMaxFolder.getParentFile(), lastIndex + 1 + "");
        if (newFolder.mkdir()) {
            return newFolder;
        }
        logger.debug("Next folder already created, retrying...");
        return this.getFirstAvailableFolder(--maxRetries);
    }

    protected File getMaxChild(File file) {
        String[] list = file.list();
        int max = -1;
        String maxChild = null;
        int current = 0;
        for (String s : list) {
            try {
                current = Integer.parseInt(s);
                if (current <= max) continue;
                maxChild = s;
                max = current;
            }
            catch (NumberFormatException nfe) {
                logger.warn("Content store contains bad folder: " + s);
            }
        }
        if (maxChild != null) {
            return new File(file, maxChild);
        }
        return null;
    }
}

