/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.adeptnet.sql.NamedParameterStatement;
import org.adeptnet.sql.SQLDataAccessException;
import org.adeptnet.sql.SQLFunction;
import org.adeptnet.sql.SQLResultSetIterator;
import org.adeptnet.sql.SQLSupplier;

public class FunctionalSql {
    private static final Logger LOG = Logger.getLogger(FunctionalSql.class.getName());
    final SQLSupplier<Connection> conProducer;

    public FunctionalSql(SQLSupplier<Connection> conProducer) {
        this.conProducer = conProducer;
    }

    private Connection con() throws SQLException, SQLDataAccessException {
        return this.conProducer.get();
    }

    public Stream<ResultSet> streamFromNamedParameterQuery(String sql, Map<String, Object> params) throws SQLDataAccessException, SQLException {
        return this.stream(this.namedParamerterQuery(sql, params), SQLFunction.identity());
    }

    public Stream<ResultSet> streamFromParameterQuery(String sql, Object ... params) throws SQLDataAccessException, SQLException {
        return this.stream(this.paramerterQuery(sql, params), SQLFunction.identity());
    }

    public Stream<ResultSet> stream(String sql) throws SQLException, SQLDataAccessException {
        return this.stream(this.executeQuery(sql), SQLFunction.identity());
    }

    public Stream<ResultSet> stream(SQLSupplier<? extends ResultSet> resultSetSupplier) throws SQLException, SQLDataAccessException {
        return this.stream(resultSetSupplier, SQLFunction.identity());
    }

    public <T> Stream<T> stream(SQLSupplier<? extends ResultSet> resultSetSupplier, SQLFunction<ResultSet, T> rowFunction) throws SQLException, SQLDataAccessException {
        SQLResultSetIterator iterator = new SQLResultSetIterator(resultSetSupplier.get(), rowFunction);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).onClose(() -> {
            try {
                iterator.close();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        });
    }

    public <T> Stream<T> stream(String sql, SQLFunction<ResultSet, T> rowFunction) throws SQLException, SQLDataAccessException {
        return this.stream(this.executeQuery(sql), rowFunction);
    }

    public SQLSupplier<? extends ResultSet> executeQuery(String sql) {
        return () -> {
            ArrayList<AutoCloseable> closables = new ArrayList<AutoCloseable>(3);
            Connection con = this.con();
            closables.add(con);
            try {
                Statement stmt = con.createStatement(1003, 1007, 2);
                closables.add(stmt);
                return stmt.executeQuery(sql);
            }
            catch (SQLException ex) {
                FunctionalSql.closeResources(closables);
                throw ex;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeQuery(SQLSupplier<? extends ResultSet> resultSetSupplier, SQLFunction<ResultSet, T> resultSetFunction) throws SQLException, SQLDataAccessException {
        ResultSet result = resultSetSupplier.get();
        try {
            T t = resultSetFunction.apply(result);
            return t;
        }
        finally {
            FunctionalSql.closeResources(result);
        }
    }

    public <T> T executeQuery(String sql, SQLFunction<ResultSet, T> resultSetFunction) throws SQLException, SQLDataAccessException {
        return this.executeQuery(this.executeQuery(sql), resultSetFunction);
    }

    public boolean execute(String sql) throws SQLException {
        return this.executeStatement(this.statement(), stmt -> stmt.execute(sql));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeStatement(SQLSupplier<? extends Statement> sqlSupplier, SQLFunction<Statement, T> sqlFunction) throws SQLException, SQLDataAccessException {
        Statement stmt = sqlSupplier.get();
        try {
            T t = sqlFunction.apply(stmt);
            return t;
        }
        finally {
            FunctionalSql.closeResources(stmt);
        }
    }

    public SQLSupplier<? extends Statement> statement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return () -> {
            ArrayList<AutoCloseable> closables = new ArrayList<AutoCloseable>(3);
            Connection con = this.con();
            closables.add(con);
            try {
                return con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            catch (SQLException ex) {
                FunctionalSql.closeResources(closables);
                throw ex;
            }
        };
    }

    public SQLSupplier<? extends Statement> statement() {
        return () -> {
            ArrayList<AutoCloseable> closables = new ArrayList<AutoCloseable>(3);
            Connection con = this.con();
            closables.add(con);
            try {
                return con.createStatement();
            }
            catch (SQLException ex) {
                FunctionalSql.closeResources(closables);
                throw ex;
            }
        };
    }

    public SQLSupplier<? extends ResultSet> namedParamerterQuery(String sql, Map<String, Object> params) {
        return () -> {
            ArrayList<AutoCloseable> closables = new ArrayList<AutoCloseable>(3);
            Connection con = this.con();
            closables.add(con);
            try {
                PreparedStatement stmt = new NamedParameterStatement(con, sql).setAll(params).getPreparedStatement();
                closables.add(stmt);
                return stmt.executeQuery();
            }
            catch (SQLException ex) {
                FunctionalSql.closeResources(closables);
                throw ex;
            }
        };
    }

    /*
     * Exception decompiling
     */
    public int namedParamerterUpdate(String sql, Map<String, Object> params) throws SQLDataAccessException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SQLSupplier<? extends ResultSet> paramerterQuery(String sql, Object ... params) {
        return () -> {
            ArrayList<AutoCloseable> closables = new ArrayList<AutoCloseable>(3);
            Connection con = this.con();
            closables.add(con);
            try {
                PreparedStatement stmt = con.prepareStatement(sql, 1003, 1007, 2);
                int cnt = 0;
                for (Object param : params) {
                    stmt.setObject(++cnt, param);
                }
                closables.add(stmt);
                return stmt.executeQuery(sql);
            }
            catch (SQLException ex) {
                FunctionalSql.closeResources(closables);
                throw ex;
            }
        };
    }

    static void closeResources(List<AutoCloseable> closables) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("closeResources");
        }
        for (AutoCloseable resource : closables) {
            try {
                resource.close();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    static void closeResources(Statement stmt) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("closeResources stmt");
        }
        FunctionalSql.closeResources(FunctionalSql.getClosableResources(stmt));
    }

    static void closeResources(ResultSet rs) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("closeResources rs");
        }
        FunctionalSql.closeResources(FunctionalSql.getClosableResources(rs));
    }

    static List<AutoCloseable> getClosableResources(ResultSet rs) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("getClosableResources rs");
        }
        ArrayList<AutoCloseable> closables = new ArrayList<AutoCloseable>(3);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer(String.format("getClosableResources rs %s", rs));
        }
        closables.add(rs);
        try {
            closables.addAll(FunctionalSql.getClosableResources(rs.getStatement()));
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return closables;
    }

    static List<AutoCloseable> getClosableResources(Statement stmt) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("getClosableResources stmt");
        }
        ArrayList<AutoCloseable> closables = new ArrayList<AutoCloseable>(2);
        try {
            if (stmt != null) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer(String.format("getClosableResources stmt %s - %s", stmt, stmt.getConnection()));
                }
                closables.add(stmt);
                closables.add(stmt.getConnection());
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return closables;
    }
}

