/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamedParameterStatement
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(NamedParameterStatement.class.getName());
    private final PreparedStatement prepStmt;
    private final Map<String, List<Integer>> fields = new HashMap<String, List<Integer>>();

    public NamedParameterStatement(Connection conn, String statementWithNames) throws SQLException {
        Pattern findParametersPattern = Pattern.compile("(?<!')(:[\\w]+)(?!')");
        Matcher matcher = findParametersPattern.matcher(statementWithNames);
        int pos = 1;
        StringBuffer sb = new StringBuffer(statementWithNames.length());
        while (matcher.find()) {
            String name = matcher.group().substring(1);
            LOGGER.log(Level.INFO, "Adding {0} to name {1}", new Object[]{pos, name});
            if (!this.fields.containsKey(name)) {
                this.fields.put(name, new LinkedList());
            }
            this.fields.get(name).add(pos);
            matcher.appendReplacement(sb, "?");
            ++pos;
        }
        matcher.appendTail(sb);
        LOGGER.log(Level.INFO, "Final Parameter mappings {0}", new Object[]{this.fields.toString()});
        this.prepStmt = conn.prepareStatement(sb.toString(), 1003, 1007, 2);
    }

    public NamedParameterStatement setAll(Map<String, ?> params) throws SQLException {
        this.clearParameters();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            if (!this.fields.containsKey(entry.getKey())) continue;
            this.setObject(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public PreparedStatement getPreparedStatement() {
        return this.prepStmt;
    }

    public boolean execute() throws SQLException {
        return this.prepStmt.execute();
    }

    public int executeUpdate() throws SQLException {
        return this.prepStmt.executeUpdate();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.prepStmt.executeQuery();
    }

    public void addBatch() throws SQLException {
        this.prepStmt.addBatch();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.prepStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.prepStmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.prepStmt.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.prepStmt.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.prepStmt.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.prepStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.prepStmt.setQueryTimeout(seconds);
    }

    public void clearWarnings() throws SQLException {
        this.prepStmt.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.prepStmt.setCursorName(name);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.prepStmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.prepStmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.prepStmt.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.prepStmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.prepStmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.prepStmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.prepStmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.prepStmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.prepStmt.getResultSetType();
    }

    public void clearBatch() throws SQLException {
        this.prepStmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.prepStmt.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.prepStmt.getConnection();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.prepStmt.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.prepStmt.getGeneratedKeys();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.prepStmt.getResultSetHoldability();
    }

    public boolean isClosed() throws SQLException {
        return this.prepStmt.isClosed();
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.prepStmt.setPoolable(poolable);
    }

    public boolean isPoolable() throws SQLException {
        return this.prepStmt.isPoolable();
    }

    public void closeOnCompletion() throws SQLException {
        this.prepStmt.closeOnCompletion();
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return this.prepStmt.isCloseOnCompletion();
    }

    public long getLargeUpdateCount() throws SQLException {
        return this.prepStmt.getLargeUpdateCount();
    }

    public void setLargeMaxRows(long max) throws SQLException {
        this.prepStmt.setLargeMaxRows(max);
    }

    public long getLargeMaxRows() throws SQLException {
        return this.prepStmt.getLargeMaxRows();
    }

    public long[] executeLargeBatch() throws SQLException {
        return this.prepStmt.executeLargeBatch();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.prepStmt)) {
            return (T)this.prepStmt;
        }
        return this.prepStmt.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.prepStmt) || this.prepStmt.isWrapperFor(iface);
    }

    public long executeLargeUpdate() throws SQLException {
        return this.prepStmt.executeLargeUpdate();
    }

    @Override
    public void close() throws SQLException {
        this.prepStmt.close();
    }

    public void cancel() throws SQLException {
        this.prepStmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.prepStmt.getWarnings();
    }

    public void setNull(String name, int sqlType) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setNull(parameterIndex, sqlType);
        }
    }

    public void setBoolean(String name, boolean x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBoolean(parameterIndex, x);
        }
    }

    public void setByte(String name, byte x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setByte(parameterIndex, x);
        }
    }

    public void setShort(String name, short x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setShort(parameterIndex, x);
        }
    }

    public void setInt(String name, int x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setInt(parameterIndex, x);
        }
    }

    public void setLong(String name, long x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setLong(parameterIndex, x);
        }
    }

    public void setFloat(String name, float x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setFloat(parameterIndex, x);
        }
    }

    public void setDouble(String name, double x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setDouble(parameterIndex, x);
        }
    }

    public void setBigDecimal(String name, BigDecimal x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBigDecimal(parameterIndex, x);
        }
    }

    public void setString(String name, String x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setString(parameterIndex, x);
        }
    }

    public void setBytes(String name, byte[] x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBytes(parameterIndex, x);
        }
    }

    public void setDate(String name, Date x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setDate(parameterIndex, x);
        }
    }

    public void setTime(String name, Time x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setTime(parameterIndex, x);
        }
    }

    public void setTimestamp(String name, Timestamp x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setTimestamp(parameterIndex, x);
        }
    }

    public void setAsciiStream(String name, InputStream x, int length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setAsciiStream(parameterIndex, x, length);
        }
    }

    public void setBinaryStream(String name, InputStream x, int length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void clearParameters() throws SQLException {
        this.prepStmt.clearParameters();
    }

    public void setObject(String name, Object x, int targetSqlType) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setObject(parameterIndex, x, targetSqlType);
        }
    }

    public void setObject(String name, Object x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setObject(parameterIndex, x);
        }
    }

    public void setCharacterStream(String name, Reader reader, int length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setCharacterStream(parameterIndex, reader, length);
        }
    }

    public void setRef(String name, Ref x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setRef(parameterIndex, x);
        }
    }

    public void setBlob(String name, Blob x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBlob(parameterIndex, x);
        }
    }

    public void setClob(String name, Clob x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setClob(parameterIndex, x);
        }
    }

    public void setArray(String name, Array x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setArray(parameterIndex, x);
        }
    }

    public void setDate(String name, Date x, Calendar cal) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setDate(parameterIndex, x, cal);
        }
    }

    public void setTime(String name, Time x, Calendar cal) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setTime(parameterIndex, x, cal);
        }
    }

    public void setTimestamp(String name, Timestamp x, Calendar cal) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setTimestamp(parameterIndex, x, cal);
        }
    }

    public void setNull(String name, int sqlType, String typeName) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setNull(parameterIndex, sqlType, typeName);
        }
    }

    public void setURL(String name, URL x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setURL(parameterIndex, x);
        }
    }

    public void setRowId(String name, RowId x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setRowId(parameterIndex, x);
        }
    }

    public void setNString(String name, String value) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setNString(parameterIndex, value);
        }
    }

    public void setNCharacterStream(String name, Reader value, long length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setNCharacterStream(parameterIndex, value, length);
        }
    }

    public void setNClob(String name, NClob value) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setNClob(parameterIndex, value);
        }
    }

    public void setClob(String name, Reader reader, long length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setClob(parameterIndex, reader, length);
        }
    }

    public void setBlob(String name, InputStream inputStream, long length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBlob(parameterIndex, inputStream, length);
        }
    }

    public void setNClob(String name, Reader reader, long length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setNClob(parameterIndex, reader, length);
        }
    }

    public void setSQLXML(String name, SQLXML xmlObject) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setSQLXML(parameterIndex, xmlObject);
        }
    }

    public void setObject(String name, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
    }

    public void setAsciiStream(String name, InputStream x, long length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setAsciiStream(parameterIndex, x, length);
        }
    }

    public void setBinaryStream(String name, InputStream x, long length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setCharacterStream(String name, Reader reader, long length) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setCharacterStream(parameterIndex, reader, length);
        }
    }

    public void setAsciiStream(String name, InputStream x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setAsciiStream(parameterIndex, x);
        }
    }

    public void setBinaryStream(String name, InputStream x) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBinaryStream(parameterIndex, x);
        }
    }

    public void setCharacterStream(String name, Reader reader) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setCharacterStream(parameterIndex, reader);
        }
    }

    public void setNCharacterStream(String name, Reader value) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setNCharacterStream(parameterIndex, value);
        }
    }

    public void setClob(String name, Reader reader) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setClob(parameterIndex, reader);
        }
    }

    public void setBlob(String name, InputStream inputStream) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setBlob(parameterIndex, inputStream);
        }
    }

    public void setNClob(String name, Reader reader) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setNClob(parameterIndex, reader);
        }
    }

    public void setObject(String name, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
    }

    public void setObject(String name, Object x, SQLType targetSqlType) throws SQLException {
        for (int parameterIndex : this.getIndices(name)) {
            this.prepStmt.setObject(parameterIndex, x, targetSqlType);
        }
    }

    private List<Integer> getIndices(String paramName) throws SQLException {
        if (this.fields.containsKey(paramName)) {
            return this.fields.get(paramName);
        }
        throw new SQLException("Statement does not contain parameter : " + paramName);
    }

    public String toString() {
        return this.prepStmt.toString();
    }
}

