/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.sql;

import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Consumer;
import org.adeptnet.sql.SQLDataAccessException;

@FunctionalInterface
public interface SQLConsumer<T> {
    public void accept(T var1) throws SQLException, SQLDataAccessException;

    default public SQLConsumer<T> andThen(SQLConsumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    public static <T> Consumer<T> checked(SQLConsumer<T> sqlConsumer) {
        return t -> {
            try {
                sqlConsumer.accept(t);
            }
            catch (SQLException ex) {
                throw new SQLDataAccessException(ex.getMessage(), ex);
            }
        };
    }
}

