/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.sql;

import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Function;
import org.adeptnet.sql.SQLDataAccessException;

@FunctionalInterface
public interface SQLFunction<T, R> {
    public R apply(T var1) throws SQLException, SQLDataAccessException;

    default public <V> SQLFunction<V, R> compose(SQLFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> SQLFunction<T, V> andThen(SQLFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    public static <T> SQLFunction<T, T> identity() {
        return t -> t;
    }

    public static <A, T> Function<A, T> checked(SQLFunction<A, T> sqlFunction) {
        return a -> {
            try {
                return sqlFunction.apply(a);
            }
            catch (SQLException ex) {
                throw new SQLDataAccessException(ex.getMessage(), ex);
            }
        };
    }
}

