/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.sql;

import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Predicate;
import org.adeptnet.sql.SQLDataAccessException;

@FunctionalInterface
public interface SQLPredicate<T> {
    public boolean test(T var1) throws SQLException, SQLDataAccessException;

    default public SQLPredicate<T> and(SQLPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public SQLPredicate<T> negate() {
        return t -> !this.test(t);
    }

    default public SQLPredicate<T> or(SQLPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T> SQLPredicate<T> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : object2 -> targetRef.equals(object2);
    }

    public static <T> Predicate<T> checked(SQLPredicate<T> sqlPredicate) {
        return t -> {
            try {
                return sqlPredicate.test(t);
            }
            catch (SQLException ex) {
                throw new SQLDataAccessException(ex.getMessage(), ex);
            }
        };
    }
}

