/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.adeptnet.sql.ForwardOnlyReadResultSet;
import org.adeptnet.sql.FunctionalSql;
import org.adeptnet.sql.SQLDataAccessException;
import org.adeptnet.sql.SQLFunction;

public class SQLResultSetIterator<T>
implements Iterator<T> {
    private static final Logger LOG = Logger.getLogger(SQLResultSetIterator.class.getName());
    private final SQLFunction<ResultSet, T> rowFunction;
    private final ResultSet rs;
    private final ResultSet wrapper;
    private Boolean hasNext;

    public SQLResultSetIterator(ResultSet rs, SQLFunction<ResultSet, T> rowFunction) {
        this.rowFunction = rowFunction;
        this.rs = rs;
        this.wrapper = new ForwardOnlyReadResultSet(rs);
    }

    @Override
    public boolean hasNext() throws SQLDataAccessException {
        try {
            if (this.hasNext == null) {
                this.hasNext = this.rs.next();
            }
            return this.hasNext;
        }
        catch (SQLException e) {
            this.close();
            throw new SQLDataAccessException(e.getMessage(), e);
        }
    }

    @Override
    public T next() throws SQLDataAccessException {
        try {
            T t;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                t = this.rowFunction.apply(this.wrapper);
            }
            catch (SQLException | SQLDataAccessException ex) {
                this.close();
                throw new SQLDataAccessException(ex.getMessage(), ex);
            }
            return t;
        }
        finally {
            this.hasNext = null;
        }
    }

    public void close() {
        if (this.rs != null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Closing rs");
            }
            FunctionalSql.closeResources(this.rs);
        }
    }
}

