/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.sql;

import java.sql.SQLException;
import java.util.function.Supplier;
import org.adeptnet.sql.SQLDataAccessException;

@FunctionalInterface
public interface SQLSupplier<T> {
    public T get() throws SQLException, SQLDataAccessException;

    public static <T> Supplier<T> checked(SQLSupplier<T> sqlSupplier) {
        return () -> {
            try {
                return sqlSupplier.get();
            }
            catch (SQLException ex) {
                throw new SQLDataAccessException(ex.getMessage(), ex);
            }
        };
    }
}

