/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.awt;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.jemmy.control.ScreenArea;
import org.jemmy.image.awt.Utils;

public class PNGEncoder {
    public static final byte BW_MODE = 0;
    public static final byte GREYSCALE_MODE = 1;
    public static final byte COLOR_MODE = 2;
    OutputStream out;
    CRC32 crc = new CRC32();
    byte mode;

    public PNGEncoder(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public PNGEncoder(OutputStream out) {
        this(out, 1);
    }

    public PNGEncoder(OutputStream out, byte mode) {
        this.out = out;
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException("Unknown color mode");
        }
        this.mode = mode;
    }

    void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        this.write(b);
    }

    void write(byte[] b) throws IOException {
        this.out.write(b);
        this.crc.update(b);
    }

    public void encode(BufferedImage image) throws IOException {
        this.encode(image, true);
    }

    public void encode(BufferedImage image, boolean closeStream) throws IOException {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        byte[] id = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13};
        this.write(id);
        this.crc.reset();
        this.write("IHDR".getBytes());
        this.write(width);
        this.write(height);
        byte[] head = null;
        switch (this.mode) {
            case 0: {
                head = new byte[]{1, 0, 0, 0, 0};
                break;
            }
            case 1: {
                head = new byte[]{8, 0, 0, 0, 0};
                break;
            }
            case 2: {
                head = new byte[]{8, 2, 0, 0, 0};
            }
        }
        this.write(head);
        this.write((int)this.crc.getValue());
        ByteArrayOutputStream compressed = new ByteArrayOutputStream(65536);
        BufferedOutputStream bos = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)compressed, new Deflater(9)));
        switch (this.mode) {
            case 0: {
                int rest = width % 8;
                int bytes = width / 8;
                for (int y = 0; y < height; ++y) {
                    int color;
                    int pixel;
                    int colorset;
                    bos.write(0);
                    for (int x = 0; x < bytes; ++x) {
                        colorset = 0;
                        for (int sh = 0; sh < 8; ++sh) {
                            pixel = image.getRGB(x * 8 + sh, y);
                            color = pixel >> 16 & 0xFF;
                            color += pixel >> 8 & 0xFF;
                            colorset <<= 1;
                            if ((color += pixel & 0xFF) < 384) continue;
                            colorset |= 1;
                        }
                        bos.write((byte)colorset);
                    }
                    if (rest <= 0) continue;
                    colorset = 0;
                    for (int sh = 0; sh < width % 8; ++sh) {
                        pixel = image.getRGB(bytes * 8 + sh, y);
                        color = pixel >> 16 & 0xFF;
                        color += pixel >> 8 & 0xFF;
                        colorset <<= 1;
                        if ((color += pixel & 0xFF) < 384) continue;
                        colorset |= 1;
                    }
                    bos.write((byte)(colorset <<= 8 - rest));
                }
                break;
            }
            case 1: {
                for (int y = 0; y < height; ++y) {
                    bos.write(0);
                    for (int x = 0; x < width; ++x) {
                        int pixel = image.getRGB(x, y);
                        int color = pixel >> 16 & 0xFF;
                        color += pixel >> 8 & 0xFF;
                        bos.write((byte)((color += pixel & 0xFF) / 3));
                    }
                }
                break;
            }
            case 2: {
                for (int y = 0; y < height; ++y) {
                    bos.write(0);
                    for (int x = 0; x < width; ++x) {
                        int pixel = image.getRGB(x, y);
                        bos.write((byte)(pixel >> 16 & 0xFF));
                        bos.write((byte)(pixel >> 8 & 0xFF));
                        bos.write((byte)(pixel & 0xFF));
                    }
                }
                break;
            }
        }
        bos.close();
        this.write(compressed.size());
        this.crc.reset();
        this.write("IDAT".getBytes());
        this.write(compressed.toByteArray());
        this.write((int)this.crc.getValue());
        this.write(0);
        this.crc.reset();
        this.write("IEND".getBytes());
        this.write((int)this.crc.getValue());
        this.out.flush();
        if (closeStream) {
            this.out.close();
        }
    }

    public static void captureScreen(Rectangle rect, String fileName) {
        PNGEncoder.captureScreen(rect, fileName, (byte)1);
    }

    public static void captureScreen(Rectangle rect, String fileName, byte mode) {
        try {
            BufferedImage capture = new Robot().createScreenCapture(rect);
            BufferedOutputStream file = new BufferedOutputStream(new FileOutputStream(fileName));
            PNGEncoder encoder = new PNGEncoder(file, mode);
            encoder.encode(capture);
        }
        catch (AWTException awte) {
            awte.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void captureScreen(ScreenArea comp, String fileName) {
        PNGEncoder.captureScreen(comp, fileName, (byte)1);
    }

    public static void captureScreen(ScreenArea comp, String fileName, byte mode) {
        PNGEncoder.captureScreen(Utils.convert(comp.getScreenBounds()), fileName, mode);
    }

    public static void captureScreen(String fileName) {
        PNGEncoder.captureScreen(fileName, (byte)1);
    }

    public static void captureScreen(String fileName, byte mode) {
        PNGEncoder.captureScreen(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()), fileName, mode);
    }
}

