/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input.awt;

import org.jemmy.Point;
import org.jemmy.Rectangle;
import org.jemmy.env.Environment;
import org.jemmy.env.Timeout;
import org.jemmy.image.Image;
import org.jemmy.input.awt.RobotExecutor;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Modifier;
import org.jemmy.interfaces.Mouse;

public class RobotDriver {
    private static boolean haveOldPos = false;
    private static int smoothness;
    private static double oldX;
    private static double oldY;
    static final int SHIFT_MASK = 65;
    static final int ALT_GRAPH_MASK = 8224;
    static final int ALT_MASK = 520;
    static final int META_MASK = 260;
    static final int CTRL_MASK = 130;

    public static void setMouseSmoothness(int mouseSmoothness) {
        smoothness = mouseSmoothness;
    }

    public static int getMouseSmoothness() {
        return smoothness;
    }

    public RobotDriver(Timeout autoDelay) {
        RobotExecutor.get().setAutoDelay(autoDelay);
    }

    public RobotDriver(Environment env) {
        this(env.getTimeout("RobotDriver.DelayTimeout"));
    }

    public static Image createScreenCapture(Rectangle screenRect) {
        return RobotExecutor.get().createScreenCapture(screenRect);
    }

    public void pressMouse(Mouse.MouseButton mouseButton, Modifier ... modifiers) {
        this.pressModifiers(modifiers);
        this.makeAnOperation("mousePress", new Object[]{mouseButton}, new Class[]{Mouse.MouseButton.class});
    }

    public void releaseMouse(Mouse.MouseButton mouseButton, Modifier ... modifiers) {
        this.makeAnOperation("mouseRelease", new Object[]{mouseButton}, new Class[]{Mouse.MouseButton.class});
        this.releaseModifiers(modifiers);
    }

    public void moveMouse(Point point) {
        double targetX = point.x;
        double targetY = point.y;
        if (haveOldPos && (oldX != targetX || oldY != targetY)) {
            double currX = oldX;
            double currY = oldY;
            double hyp = Math.sqrt((targetX - currX) * (targetX - currX) + (targetY - currY) * (targetY - currY));
            double steps = Math.ceil(hyp / Math.min(hyp, (double)smoothness));
            double vx = (targetX - currX) / steps;
            double vy = (targetY - currY) / steps;
            assert ((double)((long)vx) * vx + (double)((long)vy) * vy <= (double)((long)smoothness * (long)smoothness));
            while (Math.round(currX) != Math.round(targetX) || Math.round(currY) != Math.round(targetY)) {
                this.makeAnOperation("mouseMove", new Object[]{new Integer((int)Math.round(currX += vx)), new Integer((int)Math.round(currY += vy))}, new Class[]{Integer.TYPE, Integer.TYPE});
            }
        } else {
            this.makeAnOperation("mouseMove", new Object[]{new Integer(point.x), new Integer(point.y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        }
        haveOldPos = true;
        oldX = targetX;
        oldY = targetY;
    }

    public void clickMouse(Point point, int clickCount, Mouse.MouseButton mouseButton, Timeout mouseClick, Modifier ... modifiers) {
        this.pressModifiers(modifiers);
        this.moveMouse(point);
        this.makeAnOperation("mousePress", new Object[]{mouseButton}, new Class[]{Mouse.MouseButton.class});
        for (int i = 1; i < clickCount; ++i) {
            this.makeAnOperation("mouseRelease", new Object[]{mouseButton}, new Class[]{Mouse.MouseButton.class});
            this.makeAnOperation("mousePress", new Object[]{mouseButton}, new Class[]{Mouse.MouseButton.class});
        }
        mouseClick.sleep();
        this.makeAnOperation("mouseRelease", new Object[]{mouseButton}, new Class[]{Mouse.MouseButton.class});
        this.releaseModifiers(modifiers);
    }

    public void dragMouse(Point point, int mouseButton, int modifiers) {
        this.moveMouse(point);
    }

    public void dragNDrop(Point startPoint, Point endPoint, Mouse.MouseButton mouseButton, Modifier[] modifiers, Timeout before, Timeout after) {
        this.moveMouse(startPoint);
        this.pressMouse(mouseButton, modifiers);
        before.sleep();
        this.moveMouse(endPoint);
        after.sleep();
        this.releaseMouse(mouseButton, modifiers);
    }

    public void pressKey(Keyboard.KeyboardButton kbdButton, Modifier ... modifiers) {
        this.pressModifiers(modifiers);
        this.makeAnOperation("keyPress", new Object[]{kbdButton}, new Class[]{Keyboard.KeyboardButton.class});
    }

    public void releaseKey(Keyboard.KeyboardButton kbdButton, Modifier ... modifiers) {
        this.makeAnOperation("keyRelease", new Object[]{kbdButton}, new Class[]{Keyboard.KeyboardButton.class});
        this.releaseModifiers(modifiers);
    }

    public void turnWheel(Point p, int amount, Modifier ... modifiers) {
        this.pressModifiers(modifiers);
        this.moveMouse(p);
        Object r = null;
        this.makeAnOperation("mouseWheel", new Object[]{amount}, new Class[]{Integer.TYPE});
        this.releaseModifiers(modifiers);
    }

    public void makeAnOperation(String method, Object[] params, Class[] paramClasses) {
        RobotExecutor.get().makeAnOperation(method, params, paramClasses);
    }

    protected void pressModifiers(Modifier ... modifiers) {
        for (Modifier modifier : modifiers) {
            if (modifier == Keyboard.KeyboardModifiers.ALT_DOWN_MASK) {
                this.pressKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.ALT, new Modifier[0]);
                continue;
            }
            if (modifier == Keyboard.KeyboardModifiers.CTRL_DOWN_MASK) {
                this.pressKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.CONTROL, new Modifier[0]);
                continue;
            }
            if (modifier == Keyboard.KeyboardModifiers.META_DOWN_MASK) {
                this.pressKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.META, new Modifier[0]);
                continue;
            }
            if (modifier != Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK) continue;
            this.pressKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.SHIFT, new Modifier[0]);
        }
    }

    protected void releaseModifiers(Modifier ... modifiers) {
        for (Modifier modifier : modifiers) {
            if (modifier == Keyboard.KeyboardModifiers.ALT_DOWN_MASK) {
                this.releaseKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.ALT, new Modifier[0]);
                continue;
            }
            if (modifier == Keyboard.KeyboardModifiers.CTRL_DOWN_MASK) {
                this.releaseKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.CONTROL, new Modifier[0]);
                continue;
            }
            if (modifier == Keyboard.KeyboardModifiers.META_DOWN_MASK) {
                this.releaseKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.META, new Modifier[0]);
                continue;
            }
            if (modifier != Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK) continue;
            this.releaseKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.SHIFT, new Modifier[0]);
        }
    }

    public static void exit() {
        RobotExecutor.get().exit();
    }

    static {
        Environment.getEnvironment().setTimeout(new Timeout("RobotDriver.DelayTimeout", 10L));
        Environment.getEnvironment().setPropertyIfNotSet("awt.robot.mouse.smoothness", (Object)Integer.toString(Integer.MAX_VALUE));
        smoothness = Integer.parseInt((String)Environment.getEnvironment().getProperty("awt.robot.mouse.smoothness"));
    }
}

