/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.browser;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ReflectionPanel
extends JPanel {
    DefaultTreeModel model;
    private JScrollPane jScrollPane1;
    private JTree tree;

    public ReflectionPanel() {
        this.initComponents();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        this.model = new DefaultTreeModel(root);
        this.tree.setModel(this.model);
    }

    public DefaultTreeModel getTreeModel() {
        return this.model;
    }

    public void setControl(Class controlClass) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Class cls = controlClass;
        do {
            root.add(this.getClassNode(cls));
        } while ((cls = cls.getSuperclass()) != null);
        for (Class<?> i : controlClass.getInterfaces()) {
            root.add(this.getClassNode(i));
        }
        this.model.setRoot(root);
        this.tree.setModel(this.model);
        this.revalidate();
    }

    private DefaultMutableTreeNode getClassNode(Class cls) {
        DefaultMutableTreeNode classNode = new DefaultMutableTreeNode((cls.isInterface() ? "Interface " : "Class ") + cls.getName());
        for (Method method : cls.getMethods()) {
            StringBuffer signature = new StringBuffer(method.getReturnType().getName());
            signature.append(" " + method.getName() + "(");
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                signature.append(method.getParameterTypes()[i].getName());
                if (i >= method.getParameterTypes().length - 1) continue;
                signature.append(",");
            }
            signature.append(")");
            classNode.add(new DefaultMutableTreeNode(signature.toString()));
        }
        for (AccessibleObject accessibleObject : cls.getFields()) {
            classNode.add(new DefaultMutableTreeNode(((Field)accessibleObject).getType().getName() + " " + ((Field)accessibleObject).getName()));
        }
        return classNode;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.jScrollPane1.setViewportView(this.tree);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
    }
}

