/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.grep;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.impl.util.FileLister;
import org.aesh.io.Resource;

@CommandDefinition(name="grep", description="[OPTION]... PATTERN [FILE]...\nSearch for PATTERN in each FILE or standard input.\nPATTERN is, by default, a basic regular expression (BRE).\nExample: grep -i 'hello world' menu.h main.c\n")
public class Grep
implements Command<CommandInvocation> {
    @Option(shortName=72, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=105, name="ignore-case", hasValue=false, description="ignore case distinctions")
    private boolean ignoreCase;
    @Arguments(completer=GrepCompletor.class, description="The pattern to grep followed by file paths.")
    private List<String> arguments;
    private Pattern pattern;

    public List<String> getArguments() {
        return this.arguments;
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        block8: {
            if (this.help || this.arguments == null || this.arguments.size() == 0) {
                commandInvocation.println(commandInvocation.getHelpInfo("grep"), true);
                return CommandResult.SUCCESS;
            }
            try {
                this.pattern = this.ignoreCase ? Pattern.compile(this.arguments.remove(0), 2) : Pattern.compile(this.arguments.remove(0));
            }
            catch (PatternSyntaxException pse) {
                commandInvocation.println("grep: invalid pattern.");
                return CommandResult.FAILURE;
            }
            try {
                if (commandInvocation.getConfiguration().getPipedData() != null && commandInvocation.getConfiguration().getPipedData().available() > 0) {
                    Scanner s = new Scanner(commandInvocation.getConfiguration().getPipedData()).useDelimiter("\\A");
                    String input = s.hasNext() ? s.next() : "";
                    ArrayList<String> inputLines = new ArrayList<String>();
                    Collections.addAll(inputLines, input.split("\\R"));
                    this.doGrep(inputLines, commandInvocation);
                    break block8;
                }
                if (this.arguments != null && this.arguments.size() > 0) {
                    for (String s : this.arguments) {
                        this.doGrep(commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory().newInstance(s), commandInvocation);
                    }
                    break block8;
                }
                commandInvocation.println("grep: no file or input given.");
                return CommandResult.SUCCESS;
            }
            catch (IOException ex) {
                throw new CommandException((Throwable)ex);
            }
        }
        return null;
    }

    private void doGrep(Resource file, CommandInvocation invocation) throws IOException {
        if (!file.exists()) {
            invocation.println("grep: " + file.toString() + ": No such file or directory");
        } else if (file.isLeaf()) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(file.read()));
            ArrayList<String> inputLines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                inputLines.add(line);
            }
            this.doGrep(inputLines, invocation);
        }
    }

    private void doGrep(List<String> inputLines, CommandInvocation invocation) {
        if (this.pattern != null) {
            for (String line : inputLines) {
                if (line == null || !this.pattern.matcher(line).find()) continue;
                invocation.println(line, true);
            }
        } else {
            invocation.println("No pattern given");
        }
    }

    public static class GrepCompletor
    implements OptionCompleter<CompleterInvocation> {
        public void complete(CompleterInvocation completerData) {
            Grep grep = (Grep)completerData.getCommand();
            if (grep.getArguments() != null && grep.getArguments().size() > 0) {
                AeshCompleteOperation completeOperation = new AeshCompleteOperation(completerData.getAeshContext(), completerData.getGivenCompleteValue(), 0);
                ArrayList candidates = new ArrayList();
                if (completerData.getGivenCompleteValue() == null) {
                    new FileLister("", completerData.getAeshContext().getCurrentWorkingDirectory()).findMatchingDirectories(candidates);
                    completeOperation.addCompletionCandidates(candidates);
                } else {
                    int offset = new FileLister(completerData.getGivenCompleteValue(), completerData.getAeshContext().getCurrentWorkingDirectory()).findMatchingDirectories(candidates);
                    completeOperation.addCompletionCandidates(candidates);
                    completeOperation.setOffset(completerData.getGivenCompleteValue().length() - offset);
                }
                if (completeOperation.getCompletionCandidates().size() > 1) {
                    completeOperation.removeEscapedSpacesFromCompletionCandidates();
                }
                completerData.setCompleterValuesTerminalString(completeOperation.getCompletionCandidates());
                completerData.setOffset(completeOperation.getOffset());
                if (completerData.getGivenCompleteValue() != null && completerData.getCompleterValues().size() == 1) {
                    completerData.setAppendSpace(completeOperation.hasAppendSeparator());
                }
            }
        }
    }
}

