/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.logging.Logger;
import org.aesh.readline.Buffer;
import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.Prompt;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.history.History;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.readline.paste.PasteManager;
import org.aesh.readline.undo.UndoAction;
import org.aesh.readline.undo.UndoManager;
import org.aesh.tty.Connection;
import org.aesh.tty.Size;
import org.aesh.util.ANSI;
import org.aesh.util.Config;
import org.aesh.util.LoggerUtil;

public class AeshConsoleBuffer
implements ConsoleBuffer {
    private EditMode editMode;
    private final Buffer buffer;
    private final Connection connection;
    private final UndoManager undoManager;
    private final PasteManager pasteManager;
    private final History history;
    private final CompletionHandler completionHandler;
    private Size size;
    private final boolean ansiMode;
    private final boolean isLogging = true;
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshConsoleBuffer.class.getName());

    public AeshConsoleBuffer(Connection connection, Prompt prompt, EditMode editMode, History history, CompletionHandler completionHandler, Size size, boolean ansi) {
        this.connection = connection;
        this.ansiMode = ansi;
        this.buffer = new Buffer(prompt);
        this.pasteManager = new PasteManager();
        this.undoManager = new UndoManager();
        if (history == null) {
            this.history = new InMemoryHistory();
            this.history.enable();
        } else {
            this.history = history;
        }
        this.completionHandler = completionHandler;
        this.size = size;
        this.editMode = editMode;
    }

    @Override
    public History getHistory() {
        return this.history;
    }

    @Override
    public CompletionHandler getCompleter() {
        return this.completionHandler;
    }

    @Override
    public void setSize(Size size) {
        this.size = size;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void addActionToUndoStack() {
        this.undoManager.addUndo(new UndoAction(this.getBuffer().getCursor(), this.getBuffer().getMultiLine()));
    }

    @Override
    public PasteManager getPasteManager() {
        return this.pasteManager;
    }

    @Override
    public void moveCursor(int where) {
        this.buffer.move(this.connection.stdoutHandler(), where, this.getSize().getWidth(), this.isViMode());
    }

    @Override
    public void drawLine() {
        this.buffer.print(this.connection.stdoutHandler(), this.getSize().getWidth());
    }

    @Override
    public void drawLineForceDisplay() {
        this.buffer.setIsPromptDisplayed(false);
        this.buffer.print(this.connection.stdoutHandler(), this.getSize().getWidth());
    }

    @Override
    public void writeChar(char input) {
        this.buffer.insert(this.connection.stdoutHandler(), input, this.getSize().getWidth());
    }

    @Override
    public void writeOut(String out) {
        this.connection.write(out);
    }

    @Override
    public void writeOut(int[] out) {
        this.connection.stdoutHandler().accept(out);
    }

    @Override
    public void writeChars(int[] input) {
        this.buffer.insert(this.connection.stdoutHandler(), input, this.getSize().getWidth());
    }

    @Override
    public void writeString(String input) {
        if (input != null && input.length() > 0) {
            this.buffer.insert(this.connection.stdoutHandler(), input, this.getSize().getWidth());
        }
    }

    @Override
    public void setPrompt(Prompt prompt) {
        this.buffer.setPrompt(prompt, this.connection.stdoutHandler(), this.getSize().getWidth());
    }

    @Override
    public void insert(String insert, int position) {
        this.buffer.insert(this.connection.stdoutHandler(), insert, this.getSize().getWidth());
    }

    @Override
    public void insert(int[] insert) {
        this.buffer.insert(this.connection.stdoutHandler(), insert, this.getSize().getWidth());
    }

    @Override
    public void delete(int delta) {
        this.buffer.delete(this.connection.stdoutHandler(), delta, this.getSize().getWidth(), this.isViMode());
    }

    @Override
    public void upCase() {
        this.buffer.upCase(this.connection.stdoutHandler());
    }

    @Override
    public void downCase() {
        this.buffer.downCase(this.connection.stdoutHandler());
    }

    @Override
    public void changeCase() {
        this.buffer.changeCase(this.connection.stdoutHandler());
    }

    @Override
    public void replace(int[] line) {
        this.buffer.replace(this.connection.stdoutHandler(), line, this.getSize().getWidth());
    }

    @Override
    public void replace(String line) {
        this.buffer.replace(this.connection.stdoutHandler(), line, this.getSize().getWidth());
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    @Override
    public void clear(boolean includeBuffer) {
        if (!Config.isOSPOSIXCompatible()) {
            this.connection.stdoutHandler().accept(Config.CR);
        }
        this.connection.stdoutHandler().accept(ANSI.CLEAR_SCREEN);
        this.connection.stdoutHandler().accept(new int[]{27, 91, 49, 59, 49, 72});
        if (includeBuffer) {
            this.buffer.print(this.connection.stdoutHandler(), this.getSize().getWidth());
        }
    }

    private boolean isViMode() {
        return this.editMode.getMode() == EditMode.Mode.VI && this.editMode.getStatus() != EditMode.Status.EDIT;
    }
}

