/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.impl;

import java.io.FilterInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.impl.AbstractTerminal;
import org.aesh.terminal.utils.Curses;
import org.aesh.terminal.utils.ShutdownHooks;
import org.aesh.terminal.utils.Signals;
import org.aesh.tty.Capability;
import org.aesh.tty.Signal;
import org.aesh.tty.Size;

abstract class AbstractWindowsTerminal
extends AbstractTerminal {
    private static final int PIPE_SIZE = 1024;
    protected static final int ENABLE_PROCESSED_INPUT = 1;
    protected static final int ENABLE_LINE_INPUT = 2;
    protected static final int ENABLE_ECHO_INPUT = 4;
    protected static final int ENABLE_WINDOW_INPUT = 8;
    protected static final int ENABLE_MOUSE_INPUT = 16;
    protected static final int ENABLE_INSERT_MODE = 32;
    protected static final int ENABLE_QUICK_EDIT_MODE = 64;
    protected final OutputStream slaveInputPipe;
    protected final InputStream input;
    protected final OutputStream output;
    protected final PrintWriter writer;
    protected final Map<Signal, Object> nativeHandlers = new HashMap<Signal, Object>();
    protected final ShutdownHooks.Task closer;
    protected final Attributes attributes = new Attributes();
    protected final Thread pump;
    private volatile boolean closing;

    public AbstractWindowsTerminal(OutputStream output, String name, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        super(name, "windows", signalHandler);
        PipedInputStream input = new PipedInputStream(1024);
        this.slaveInputPipe = new PipedOutputStream(input);
        this.input = new FilterInputStream(input){};
        this.output = output;
        String encoding = this.getConsoleEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        this.writer = new PrintWriter(new OutputStreamWriter(output, encoding));
        this.parseInfoCmp();
        this.attributes.setLocalFlag(Attributes.LocalFlag.ISIG, true);
        this.attributes.setControlChar(Attributes.ControlChar.VINTR, this.ctrl('C'));
        this.attributes.setControlChar(Attributes.ControlChar.VEOF, this.ctrl('D'));
        this.attributes.setControlChar(Attributes.ControlChar.VSUSP, this.ctrl('Z'));
        if (nativeSignals) {
            for (Signal signal : Signal.values()) {
                this.nativeHandlers.put(signal, Signals.register(signal.name(), () -> this.raise(signal)));
            }
        }
        this.pump = new Thread(this::pump, "WindowsStreamPump");
        this.pump.start();
        this.closer = this::close;
        ShutdownHooks.add(this.closer);
    }

    @Override
    protected void handleDefaultSignal(Signal signal) {
        Object handler = this.nativeHandlers.get((Object)signal);
        if (handler != null) {
            Signals.invokeHandler(signal.name(), handler);
        }
    }

    protected String getConsoleEncoding() {
        int codepage = this.getConsoleOutputCP();
        String charsetMS = "ms" + codepage;
        if (Charset.isSupported(charsetMS)) {
            return charsetMS;
        }
        String charsetCP = "cp" + codepage;
        if (Charset.isSupported(charsetCP)) {
            return charsetCP;
        }
        return null;
    }

    protected abstract int getConsoleOutputCP();

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public Attributes getAttributes() {
        int mode = this.getConsoleMode();
        if ((mode & 4) != 0) {
            this.attributes.setLocalFlag(Attributes.LocalFlag.ECHO, true);
        }
        if ((mode & 2) != 0) {
            this.attributes.setLocalFlag(Attributes.LocalFlag.ICANON, true);
        }
        return new Attributes(this.attributes);
    }

    @Override
    public void setAttributes(Attributes attr) {
        this.attributes.copy(attr);
        int mode = 0;
        if (attr.getLocalFlag(Attributes.LocalFlag.ECHO)) {
            mode |= 4;
        }
        if (attr.getLocalFlag(Attributes.LocalFlag.ICANON)) {
            mode |= 2;
        }
        this.setConsoleMode(mode);
    }

    protected int ctrl(char key) {
        return Character.toUpperCase(key) & 0x1F;
    }

    protected abstract int getConsoleMode();

    protected abstract void setConsoleMode(int var1);

    public void setSize(Size size) {
        throw new UnsupportedOperationException("Can not resize windows terminal");
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        this.pump.interrupt();
        ShutdownHooks.remove(this.closer);
        for (Map.Entry<Signal, Object> entry : this.nativeHandlers.entrySet()) {
            Signals.unregister(entry.getKey().name(), entry.getValue());
        }
        this.writer.close();
    }

    protected abstract byte[] readConsoleInput();

    protected String getEscapeSequence(short keyCode) {
        String escapeSequence = null;
        switch (keyCode) {
            case 8: {
                escapeSequence = this.getSequence(Capability.key_backspace);
                break;
            }
            case 33: {
                escapeSequence = this.getSequence(Capability.key_ppage);
                break;
            }
            case 34: {
                escapeSequence = this.getSequence(Capability.key_npage);
                break;
            }
            case 35: {
                escapeSequence = this.getSequence(Capability.key_end);
                break;
            }
            case 36: {
                escapeSequence = this.getSequence(Capability.key_home);
                break;
            }
            case 37: {
                escapeSequence = this.getSequence(Capability.key_left);
                break;
            }
            case 38: {
                escapeSequence = this.getSequence(Capability.key_up);
                break;
            }
            case 39: {
                escapeSequence = this.getSequence(Capability.key_right);
                break;
            }
            case 40: {
                escapeSequence = this.getSequence(Capability.key_down);
                break;
            }
            case 45: {
                escapeSequence = this.getSequence(Capability.key_ic);
                break;
            }
            case 46: {
                escapeSequence = this.getSequence(Capability.key_dc);
                break;
            }
            case 112: {
                escapeSequence = this.getSequence(Capability.key_f1);
                break;
            }
            case 113: {
                escapeSequence = this.getSequence(Capability.key_f2);
                break;
            }
            case 114: {
                escapeSequence = this.getSequence(Capability.key_f3);
                break;
            }
            case 115: {
                escapeSequence = this.getSequence(Capability.key_f4);
                break;
            }
            case 116: {
                escapeSequence = this.getSequence(Capability.key_f5);
                break;
            }
            case 117: {
                escapeSequence = this.getSequence(Capability.key_f6);
                break;
            }
            case 118: {
                escapeSequence = this.getSequence(Capability.key_f7);
                break;
            }
            case 119: {
                escapeSequence = this.getSequence(Capability.key_f8);
                break;
            }
            case 120: {
                escapeSequence = this.getSequence(Capability.key_f9);
                break;
            }
            case 121: {
                escapeSequence = this.getSequence(Capability.key_f10);
                break;
            }
            case 122: {
                escapeSequence = this.getSequence(Capability.key_f11);
                break;
            }
            case 123: {
                escapeSequence = this.getSequence(Capability.key_f12);
                break;
            }
        }
        return escapeSequence;
    }

    protected String getSequence(Capability cap) {
        String str = (String)this.strings.get((Object)cap);
        if (str != null) {
            StringWriter sw = new StringWriter();
            try {
                Curses.tputs(sw, str, new Object[0]);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            return sw.toString();
        }
        return null;
    }

    protected void pump() {
        block4: {
            try {
                while (!this.closing) {
                    byte[] buf;
                    for (byte b : buf = this.readConsoleInput()) {
                        this.processInputByte(b);
                    }
                }
            }
            catch (IOException e) {
                if (this.closing) break block4;
                this.LOGGER.log(Level.WARNING, "Error in WindowsStreamPump", e);
            }
        }
    }

    public void processInputByte(int c) throws IOException {
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ISIG)) {
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VINTR)) {
                this.raise(Signal.INT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VQUIT)) {
                this.raise(Signal.QUIT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSUSP)) {
                this.raise(Signal.TSTP);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSTATUS)) {
                this.raise(Signal.INFO);
            }
        }
        if (c == 13) {
            if (this.attributes.getInputFlag(Attributes.InputFlag.IGNCR)) {
                return;
            }
            if (this.attributes.getInputFlag(Attributes.InputFlag.ICRNL)) {
                c = 10;
            }
        } else if (c == 10 && this.attributes.getInputFlag(Attributes.InputFlag.INLCR)) {
            c = 13;
        }
        this.slaveInputPipe.write(c);
        this.slaveInputPipe.flush();
    }
}

