/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.parser;

import org.aesh.parser.ParsedLine;
import org.aesh.parser.ParsedWord;

public class ParsedLineIterator {
    private final ParsedLine parsedLine;
    private int word = 0;
    private int character = 0;

    public ParsedLineIterator(ParsedLine parsedLine) {
        this.parsedLine = parsedLine;
    }

    public boolean hasNextWord() {
        return this.parsedLine.words().size() > this.word;
    }

    public boolean hasNextChar() {
        return this.parsedLine.line().length() > this.character;
    }

    public ParsedWord pollParsedWord() {
        if (this.hasNextWord()) {
            this.character = this.parsedLine.words().size() > this.word + 1 ? this.parsedLine.words().get(this.word + 1).lineIndex() : -1;
            return this.parsedLine.words().get(this.word++);
        }
        return new ParsedWord(null, -1);
    }

    public String pollWord() {
        return this.pollParsedWord().word();
    }

    public char pollChar() {
        if (this.hasNextChar()) {
            if (this.hasNextWord() && this.character + 1 >= this.parsedLine.words().get(this.word).lineIndex() + this.parsedLine.words().get(this.word).word().length()) {
                ++this.word;
            }
            return this.parsedLine.line().charAt(this.character++);
        }
        return '\u0000';
    }

    public ParsedWord peekParsedWord() {
        if (this.hasNextWord()) {
            return this.parsedLine.words().get(this.word);
        }
        return new ParsedWord(null, -1);
    }

    public String peekWord() {
        return this.peekParsedWord().word();
    }

    public boolean finished() {
        return this.parsedLine.words().size() == this.word || this.parsedLine.line().length() == this.character;
    }

    public String parserError() {
        return this.parsedLine.errorMessage();
    }
}

