/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.editing;

import java.util.Arrays;
import org.aesh.readline.action.Action;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.editing.Variable;
import org.aesh.terminal.Key;

public interface EditMode {
    public Mode getMode();

    public KeyAction[] keys();

    public Status getStatus();

    public void setStatus(Status var1);

    public Action parse(KeyAction var1);

    public boolean isInChainedAction();

    public void updateIgnoreEOF(int var1);

    public void addVariable(Variable var1, String var2);

    public String getVariableValue(Variable var1);

    public EditMode addAction(Key var1, Action var2);

    public void addAction(int[] var1, String var2);

    default public KeyAction createKeyEvent(final int[] input) {
        Key key = Key.getKey(input);
        if (key != null) {
            return key;
        }
        return new KeyAction(){
            private int[] key;
            {
                this.key = input;
            }

            @Override
            public int getCodePointAt(int index) throws IndexOutOfBoundsException {
                return this.key[index];
            }

            @Override
            public int length() {
                return this.key.length;
            }

            @Override
            public String name() {
                return Arrays.toString(this.key);
            }
        };
    }

    public static enum Mode {
        EMACS,
        VI;

    }

    public static enum Status {
        DELETE,
        MOVE,
        YANK,
        CHANGE,
        EDIT,
        COMMAND,
        HISTORY,
        SEARCH,
        REPEAT,
        NEWLINE,
        PASTE,
        PASTE_FROM_CLIPBOARD,
        COMPLETE,
        UNDO,
        CASE,
        EXIT,
        CLEAR,
        ABORT,
        CHANGE_EDITMODE,
        NO_ACTION,
        REPLACE,
        INTERRUPT,
        IGNORE_EOF,
        EOF,
        UP_CASE,
        DOWN_CASE,
        CAPITALIZE;

    }
}

