/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.formatting;

import org.aesh.terminal.formatting.CharacterType;

public class TerminalTextStyle {
    private boolean bold = false;
    private boolean faint = false;
    private boolean italic = false;
    private boolean underline = false;
    private boolean blink = false;
    private boolean invert = false;
    private boolean crossedOut = false;
    private boolean conceal = false;
    private int length = -1;
    private static byte BOLD_OFF = (byte)22;
    private static byte ITALIC_OFF = (byte)23;
    private static byte UNDERLINE_OFF = (byte)24;
    private static byte BLINK_OFF = (byte)25;
    private static byte INVERT_OFF = (byte)27;
    private static byte REVEAL = (byte)28;
    private static byte CROSSED_OUT_OFF = (byte)29;
    private static char SEPARATOR = (char)59;

    public TerminalTextStyle() {
    }

    public TerminalTextStyle(CharacterType type) {
        if (type == CharacterType.BOLD) {
            this.bold = true;
        } else if (type == CharacterType.FAINT) {
            this.faint = true;
        } else if (type == CharacterType.ITALIC) {
            this.italic = true;
        } else if (type == CharacterType.UNDERLINE) {
            this.underline = true;
        } else if (type == CharacterType.BLINK) {
            this.blink = true;
        } else if (type == CharacterType.INVERT) {
            this.invert = true;
        } else if (type == CharacterType.CROSSED_OUT) {
            this.crossedOut = true;
        } else if (type == CharacterType.CONCEAL) {
            this.conceal = true;
        }
    }

    public TerminalTextStyle(boolean bold, boolean faint, boolean italic, boolean underline, boolean blink, boolean invert, boolean crossedOut) {
        this.bold = bold;
        this.faint = faint;
        this.italic = italic;
        this.underline = underline;
        this.blink = blink;
        this.invert = invert;
        this.crossedOut = crossedOut;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isFaint() {
        return this.faint;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public boolean isBlink() {
        return this.blink;
    }

    public void setBlink(boolean blink) {
        this.blink = blink;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean isCrossedOut() {
        return this.crossedOut;
    }

    public void setCrossedOut(boolean crossedOut) {
        this.crossedOut = crossedOut;
    }

    public boolean isConceal() {
        return this.conceal;
    }

    public void setConceal(boolean conceal) {
        this.conceal = conceal;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.bold) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(CharacterType.BOLD.getValue());
        }
        if (this.faint) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(CharacterType.FAINT.getValue());
        }
        if (this.italic) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(CharacterType.ITALIC.getValue());
        }
        if (this.underline) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(CharacterType.UNDERLINE.getValue());
        }
        if (this.blink) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(CharacterType.BLINK.getValue());
        }
        if (this.invert) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(CharacterType.INVERT.getValue());
        }
        if (this.crossedOut) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(CharacterType.CROSSED_OUT.getValue());
        }
        if (this.conceal) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(CharacterType.CONCEAL.getValue());
        }
        if (this.length < 0) {
            this.length = builder.length();
        }
        return builder.toString();
    }

    public int getLength() {
        if (this.length < 0) {
            this.toString();
        }
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminalTextStyle)) {
            return false;
        }
        TerminalTextStyle that = (TerminalTextStyle)o;
        return this.blink == that.blink && this.bold == that.bold && this.crossedOut == that.crossedOut && this.faint == that.faint && this.invert == that.invert && this.italic == that.italic && this.underline == that.underline && this.conceal == that.conceal;
    }

    public int hashCode() {
        int result = this.bold ? 1 : 0;
        result = 31 * result + (this.faint ? 1 : 0);
        result = 31 * result + (this.italic ? 1 : 0);
        result = 31 * result + (this.underline ? 1 : 0);
        result = 31 * result + (this.blink ? 1 : 0);
        result = 31 * result + (this.invert ? 1 : 0);
        result = 31 * result + (this.crossedOut ? 1 : 0);
        result = 31 * result + (this.conceal ? 1 : 0);
        return result;
    }

    public String getValueComparedToPrev(TerminalTextStyle prev) {
        String str;
        StringBuilder builder = new StringBuilder();
        if (!this.equals(prev)) {
            if (prev.isBold() || prev.isFaint()) {
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                }
                builder.append(BOLD_OFF);
            }
            if (prev.isUnderline()) {
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                }
                builder.append(UNDERLINE_OFF);
            }
            if (prev.isItalic()) {
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                }
                builder.append(ITALIC_OFF);
            }
            if (prev.isBlink()) {
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                }
                builder.append(BLINK_OFF);
            }
            if (prev.isInvert()) {
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                }
                builder.append(INVERT_OFF);
            }
            if (prev.isCrossedOut()) {
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                }
                builder.append(CROSSED_OUT_OFF);
            }
            if (prev.isConceal()) {
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                }
                builder.append(REVEAL);
            }
        }
        if ((str = this.toString()).length() > 0 && builder.length() > 0) {
            return builder.append(SEPARATOR).append(str).toString();
        }
        return builder.append(str).toString();
    }
}

