/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.utils;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aesh.terminal.utils.Curses;
import org.aesh.terminal.utils.InfoCmp;
import org.aesh.tty.Capability;
import org.aesh.util.Config;
import org.aesh.util.Parser;

public class InfoCmpHelper {
    private static boolean initialized = false;
    private static Set<Capability> bools = new HashSet<Capability>();
    private static Map<Capability, Integer> ints = new HashMap<Capability, Integer>();
    private static Map<Capability, String> strings = new HashMap<Capability, String>();

    public static int[] getCurrentTranslatedCapabilityAsInts(String cap, int[] defaultValue) {
        if (Config.isWindows()) {
            return defaultValue;
        }
        String s = InfoCmpHelper.getCurrentTranslatedCapability(cap, Parser.fromCodePoints(defaultValue));
        if (s.length() == 0) {
            return defaultValue;
        }
        return s.codePoints().toArray();
    }

    public static String getCurrentTranslatedCapability(String cap, String defaultValue) {
        try {
            String capStr;
            Capability capability;
            if (!initialized) {
                String term = System.getenv("TERM");
                if (term == null) {
                    term = "xterm-256color";
                }
                String infocmp = InfoCmp.getInfoCmp(term);
                InfoCmp.parseInfoCmp(infocmp, bools, ints, strings);
                initialized = true;
            }
            if ((capability = Capability.byName(cap)) != null && (capStr = strings.get((Object)capability)) != null) {
                StringWriter sw = new StringWriter();
                Curses.tputs(sw, capStr, new Object[0]);
                return sw.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

