/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.util.LoggerUtil;

public final class ShutdownHooks {
    private static final Logger LOGGER = LoggerUtil.getLogger(ShutdownHooks.class.getName());
    private static final List<Task> tasks = new ArrayList<Task>();
    private static Thread hook;

    public static synchronized <T extends Task> T add(T task) {
        assert (task != null);
        if (hook == null) {
            hook = ShutdownHooks.addHook(new Thread("Aesh Shutdown Hook"){

                @Override
                public void run() {
                    ShutdownHooks.runTasks();
                }
            });
        }
        LOGGER.log(Level.FINE, "Adding shutdown-hook task: ", task);
        tasks.add(task);
        return task;
    }

    private static synchronized void runTasks() {
        LOGGER.log(Level.FINE, "Running all shutdown-hook tasks");
        for (Task task : tasks.toArray(new Task[tasks.size()])) {
            LOGGER.log(Level.FINE, "Running task: ", task);
            try {
                task.run();
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Task failed", e);
            }
        }
        tasks.clear();
    }

    private static Thread addHook(Thread thread) {
        LOGGER.log(Level.FINE, "Registering shutdown-hook: ", thread);
        try {
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (AbstractMethodError e) {
            LOGGER.log(Level.FINE, "Failed to register shutdown-hook", e);
        }
        return thread;
    }

    public static synchronized void remove(Task task) {
        assert (task != null);
        if (hook == null) {
            return;
        }
        tasks.remove(task);
        if (tasks.isEmpty()) {
            ShutdownHooks.removeHook(hook);
            hook = null;
        }
    }

    private static void removeHook(Thread thread) {
        LOGGER.log(Level.FINE, "Removing shutdown-hook: ", thread);
        try {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
        catch (AbstractMethodError e) {
            LOGGER.log(Level.FINE, "Failed to remove shutdown-hook", e);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static interface Task {
        public void run() throws Exception;
    }
}

