/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.Arrays;
import java.util.List;
import org.aesh.readline.terminal.formatting.TerminalCharacter;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.util.Parser;

public class Prompt {
    private int[] prompt;
    private Character mask;
    private int[] ansiString;

    public Prompt(String prompt) {
        this.prompt = prompt != null ? Parser.toCodePoints(prompt) : new int[0];
    }

    public Prompt(Prompt prompt) {
        this.prompt = (int[])prompt.prompt.clone();
        this.mask = prompt.mask;
        this.ansiString = (int[])prompt.ansiString.clone();
    }

    public Prompt(String prompt, String ansiString) {
        this.prompt = prompt != null ? Parser.toCodePoints(prompt) : new int[0];
        this.ansiString = Parser.toCodePoints(ansiString);
    }

    public Prompt(String prompt, Character mask) {
        this.prompt = prompt != null ? Parser.toCodePoints(prompt) : new int[0];
        this.mask = mask;
    }

    public Prompt(int[] prompt, Character mask) {
        if (prompt != null) {
            this.prompt = new int[prompt.length];
            System.arraycopy(prompt, 0, this.prompt, 0, prompt.length);
        } else {
            this.prompt = new int[0];
        }
        this.mask = mask;
    }

    public Prompt(TerminalString terminalString) {
        if (terminalString != null) {
            this.ansiString = Parser.toCodePoints(terminalString.toString());
            this.prompt = Parser.toCodePoints(terminalString.getCharacters());
        } else {
            this.prompt = new int[0];
        }
    }

    public Prompt(List<TerminalCharacter> characters) {
        this.generateOutString(characters);
    }

    public Prompt(List<TerminalCharacter> characters, Character mask) {
        this.mask = mask;
        this.generateOutString(characters);
    }

    private void generateOutString(List<TerminalCharacter> chars) {
        StringBuilder promptBuilder = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        TerminalCharacter prev = null;
        for (TerminalCharacter c : chars) {
            if (prev == null) {
                builder.append(c.toString());
            } else {
                builder.append(c.toString(prev));
            }
            prev = c;
            promptBuilder.append(c.getCharacter());
        }
        this.ansiString = Parser.toCodePoints(builder.toString());
        this.prompt = Parser.toCodePoints(promptBuilder.toString());
    }

    public Character getMask() {
        return this.mask;
    }

    public boolean isMasking() {
        return this.mask != null;
    }

    public int[] getPromptAsString() {
        return this.prompt;
    }

    public int getLength() {
        return this.prompt.length;
    }

    public boolean hasANSI() {
        return this.ansiString != null;
    }

    public int[] getANSI() {
        if (this.ansiString == null) {
            return this.prompt;
        }
        return this.ansiString;
    }

    public Prompt copy() {
        return new Prompt(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Prompt)) {
            return false;
        }
        Prompt prompt1 = (Prompt)o;
        if (this.ansiString != null ? !Arrays.equals(this.ansiString, prompt1.ansiString) : prompt1.ansiString != null) {
            return false;
        }
        if (this.mask != null ? !this.mask.equals(prompt1.mask) : prompt1.mask != null) {
            return false;
        }
        return Arrays.equals(this.prompt, prompt1.prompt);
    }

    public int hashCode() {
        int result = this.ansiString != null ? Arrays.hashCode(this.ansiString) : 0;
        result = 31 * result + Arrays.hashCode(this.prompt);
        result = 31 * result + (this.mask != null ? this.mask.hashCode() : 0);
        return result;
    }
}

