/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.util.FileAccessPermission;
import org.aesh.util.LoggerUtil;
import org.aesh.util.Parser;
import org.aesh.utils.Config;

public class FileHistory
extends InMemoryHistory {
    private final File historyFile;
    private final FileAccessPermission historyFilePermission;
    private final boolean logging;
    private static final Logger LOGGER = LoggerUtil.getLogger(FileHistory.class.getName());

    public FileHistory(File file, int maxSize) {
        this(file, maxSize, false);
    }

    public FileHistory(File file, int maxSize, boolean logging) {
        this(file, maxSize, null, logging);
    }

    public FileHistory(File file, int maxSize, FileAccessPermission historyFilePermission, boolean logging) {
        super(maxSize);
        this.logging = logging;
        this.historyFile = file;
        this.historyFilePermission = historyFilePermission;
        this.readFile();
    }

    private void readFile() {
        block17: {
            if (this.historyFile.exists()) {
                try (BufferedReader reader2 = new BufferedReader(new FileReader(this.historyFile));){
                    String line;
                    while ((line = reader2.readLine()) != null) {
                        this.push(Parser.toCodePoints(line));
                    }
                }
                catch (FileNotFoundException reader2) {
                }
                catch (IOException e) {
                    if (!this.logging) break block17;
                    LOGGER.log(Level.WARNING, "Failed to read from history file, ", e);
                }
            }
        }
    }

    private void writeFile() throws IOException {
        this.historyFile.delete();
        try (FileWriter fw = new FileWriter(this.historyFile);){
            for (int i = 0; i < this.size(); ++i) {
                fw.write(Parser.fromCodePoints(this.get(i)) + Config.getLineSeparator());
            }
        }
        if (this.historyFilePermission != null) {
            this.historyFile.setReadable(false, false);
            this.historyFile.setReadable(this.historyFilePermission.isReadable(), this.historyFilePermission.isReadableOwnerOnly());
            this.historyFile.setWritable(false, false);
            this.historyFile.setWritable(this.historyFilePermission.isWritable(), this.historyFilePermission.isWritableOwnerOnly());
            this.historyFile.setExecutable(false, false);
            this.historyFile.setExecutable(this.historyFilePermission.isExecutable(), this.historyFilePermission.isExecutableOwnerOnly());
        }
    }

    @Override
    public void stop() {
        block2: {
            try {
                this.writeFile();
            }
            catch (IOException e) {
                if (!this.logging) break block2;
                LOGGER.log(Level.WARNING, "Failed when trying to write history file", e);
            }
        }
    }
}

