/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.tty.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.io.Decoder;
import org.aesh.io.Encoder;
import org.aesh.readline.terminal.TerminalBuilder;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Device;
import org.aesh.terminal.EventDecoder;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.util.LoggerUtil;

public class TerminalConnection
implements Connection {
    private final Charset inputCharset;
    private final Charset outputCharset;
    private Terminal terminal;
    private static final Logger LOGGER = LoggerUtil.getLogger(TerminalConnection.class.getName());
    private Consumer<Size> sizeHandler;
    private Decoder decoder;
    private Encoder stdOut;
    private Attributes attributes;
    private EventDecoder eventDecoder;
    private volatile boolean reading = false;
    private Consumer<Void> closeHandler;
    private Consumer<Connection> handler;
    private CountDownLatch latch;
    private volatile boolean waiting = false;
    private Terminal.SignalHandler prevIntrHandler;
    private Terminal.SignalHandler prevWincHandler;
    private Terminal.SignalHandler prevContHandler;

    public TerminalConnection(Charset inputCharset, Charset outputCharset, InputStream inputStream, OutputStream outputStream, Consumer<Connection> handler) throws IOException {
        this.inputCharset = inputCharset != null ? inputCharset : Charset.defaultCharset();
        this.outputCharset = outputCharset != null ? outputCharset : Charset.defaultCharset();
        this.handler = handler;
        this.init(TerminalBuilder.builder().input(inputStream).output(outputStream).nativeSignals(true).name("Aesh console").build());
    }

    public TerminalConnection(Charset charset, InputStream inputStream, OutputStream outputStream, Consumer<Connection> handler) throws IOException {
        this(charset, charset, inputStream, outputStream, handler);
    }

    public TerminalConnection(Charset charset, InputStream inputStream, OutputStream outputStream) throws IOException {
        this(charset, charset, inputStream, outputStream, null);
    }

    public TerminalConnection() throws IOException {
        this(Charset.defaultCharset(), System.in, System.out);
    }

    public TerminalConnection(Consumer<Connection> handler) throws IOException {
        this(Charset.defaultCharset(), Charset.defaultCharset(), System.in, System.out, handler);
    }

    public TerminalConnection(Terminal terminal) {
        this.inputCharset = Charset.defaultCharset();
        this.outputCharset = Charset.defaultCharset();
        this.init(terminal);
    }

    private void init(Terminal term) {
        this.terminal = term;
        this.attributes = this.terminal.getAttributes();
        this.prevIntrHandler = this.terminal.handle(Signal.INT, s -> {
            if (this.getSignalHandler() != null) {
                this.getSignalHandler().accept(s);
            } else {
                LOGGER.log(Level.FINE, "No signal handler is registered, lets stop");
                this.close();
            }
        });
        this.prevContHandler = this.terminal.handle(Signal.CONT, s -> {
            if (this.getSignalHandler() != null) {
                this.getSignalHandler().accept(s);
            }
        });
        this.prevWincHandler = this.terminal.handle(Signal.WINCH, s -> {
            if (this.getSizeHandler() != null) {
                this.getSizeHandler().accept(this.size());
            }
        });
        this.eventDecoder = new EventDecoder(this.attributes);
        this.decoder = new Decoder(512, this.inputEncoding(), this.eventDecoder);
        this.stdOut = new Encoder(this.outputEncoding(), this::write);
        if (this.handler != null) {
            this.handler.accept(this);
        }
    }

    @Override
    public void openNonBlocking() {
        ExecutorService executorService = Executors.newSingleThreadExecutor(runnable -> {
            Thread inputThread = Executors.defaultThreadFactory().newThread(runnable);
            inputThread.setName("Aesh InputStream Reader");
            inputThread.setDaemon(true);
            return inputThread;
        });
        executorService.execute(this::openBlocking);
    }

    @Override
    public boolean put(Capability capability, Object ... params) {
        return this.terminal.device().puts(this.stdoutHandler(), capability);
    }

    @Override
    public Attributes getAttributes() {
        return this.terminal.getAttributes();
    }

    @Override
    public void setAttributes(Attributes attr) {
        this.terminal.setAttributes(attr);
    }

    @Override
    public Charset inputEncoding() {
        return this.inputCharset;
    }

    @Override
    public Charset outputEncoding() {
        return this.outputCharset;
    }

    @Override
    public void openBlocking() {
        this.openBlocking(null);
    }

    public void openBlocking(String buffer) {
        try {
            this.reading = true;
            byte[] bBuf = new byte[1024];
            if (buffer != null) {
                this.decoder.write(buffer.getBytes(this.inputCharset));
            }
            while (this.reading) {
                int read = this.terminal.input().read(bBuf);
                if (read > 0) {
                    this.decoder.write(bBuf, 0, read);
                    if (!this.waiting) continue;
                    this.latch = new CountDownLatch(1);
                    try {
                        this.latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.log(Level.WARNING, "Reader thread was interrupted while waiting on the latch", e);
                        this.close();
                    }
                    continue;
                }
                if (read >= 0) continue;
                this.close();
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Failed while reading, exiting", ioe);
            this.close();
        }
    }

    public void suspend() {
        if (!this.waiting) {
            this.waiting = true;
        }
    }

    public void awake() {
        if (this.waiting) {
            this.waiting = false;
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    public boolean suspended() {
        return this.waiting;
    }

    public boolean isReading() {
        return this.reading;
    }

    public void stopReading() {
        this.reading = false;
        this.awake();
    }

    private void write(byte[] data) {
        try {
            this.terminal.output().write(data);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to write out.", e);
        }
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public Device device() {
        return this.terminal.device();
    }

    @Override
    public Size size() {
        return this.terminal.getSize();
    }

    @Override
    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    @Override
    public void setSizeHandler(Consumer<Size> handler) {
        this.sizeHandler = handler;
    }

    @Override
    public Consumer<Signal> getSignalHandler() {
        return this.eventDecoder.getSignalHandler();
    }

    @Override
    public void setSignalHandler(Consumer<Signal> handler) {
        this.eventDecoder.setSignalHandler(handler);
    }

    @Override
    public Consumer<int[]> getStdinHandler() {
        return this.eventDecoder.getInputHandler();
    }

    @Override
    public void setStdinHandler(Consumer<int[]> handler) {
        this.eventDecoder.setInputHandler(handler);
        if (handler == null) {
            this.suspend();
        } else {
            this.awake();
        }
    }

    @Override
    public Consumer<int[]> stdoutHandler() {
        return this.stdOut;
    }

    @Override
    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    @Override
    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    @Override
    public void close() {
        try {
            this.reading = false;
            if (this.getCloseHandler() != null) {
                this.getCloseHandler().accept(null);
            }
            this.terminal.handle(Signal.INT, this.prevIntrHandler);
            this.terminal.handle(Signal.WINCH, this.prevWincHandler);
            this.terminal.handle(Signal.CONT, this.prevContHandler);
            if (this.attributes != null && this.terminal != null) {
                this.terminal.setAttributes(this.attributes);
                this.terminal.close();
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to close the terminal correctly", e);
        }
    }
}

