/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.utils.Config;

public class Parser {
    private static final String spaceEscapedMatcher = "\\ ";
    public static final String SPACE = " ";
    public static final char SPACE_CHAR = ' ';
    public static final char BACK_SLASH = '\\';
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char DOLLAR = '$';
    private static final Pattern spaceEscapedPattern = Pattern.compile("\\\\ ");
    private static final Pattern spacePattern = Pattern.compile("(?<!\\\\)\\s");
    private static final Pattern ansiPattern = Pattern.compile("\\u001B\\[[\\?]?[0-9;]*[a-zA-Z]?");
    private static final Pattern commentPattern = Pattern.compile("^(\\s*)(#)(.*)");

    public static String formatDisplayList(String[] displayList, int termHeight, int termWidth) {
        return Parser.formatDisplayList(Arrays.asList(displayList), termHeight, termWidth);
    }

    public static String formatDisplayList(List<String> displayList, int termHeight, int termWidth) {
        int numRows;
        if (displayList == null || displayList.size() < 1) {
            return "";
        }
        if (termWidth < 1) {
            termWidth = 80;
        }
        int maxLength = 0;
        for (String completion : displayList) {
            if (completion.length() <= maxLength) continue;
            maxLength = completion.length();
        }
        int numColumns = termWidth / (maxLength += 2);
        if (numColumns > displayList.size()) {
            numColumns = displayList.size();
        }
        if (numColumns < 1) {
            numColumns = 1;
        }
        if ((numRows = displayList.size() / numColumns) * numColumns < displayList.size()) {
            ++numRows;
        }
        StringBuilder completionOutput = new StringBuilder();
        for (int i = 0; i < numRows; ++i) {
            int fetch;
            for (int c = 0; c < numColumns && (fetch = i + c * numRows) < displayList.size(); ++c) {
                completionOutput.append(Parser.padRight(maxLength, displayList.get(i + c * numRows)));
            }
            completionOutput.append(Config.getLineSeparator());
        }
        return completionOutput.toString();
    }

    public static String formatDisplayListTerminalString(List<TerminalString> displayList, int termHeight, int termWidth) {
        int numRows;
        if (displayList == null || displayList.size() < 1) {
            return "";
        }
        if (termWidth < 1) {
            termWidth = 80;
        }
        int maxLength = 0;
        for (TerminalString completion : displayList) {
            if (completion.getCharacters().length() <= maxLength) continue;
            maxLength = completion.getCharacters().length();
        }
        int numColumns = termWidth / (maxLength += 2);
        if (numColumns > displayList.size()) {
            numColumns = displayList.size();
        }
        if (numColumns < 1) {
            numColumns = 1;
        }
        if ((numRows = displayList.size() / numColumns) * numColumns < displayList.size()) {
            ++numRows;
        }
        StringBuilder completionOutput = new StringBuilder();
        if (numRows > 1) {
            for (int i = 0; i < numRows; ++i) {
                int fetch;
                for (int c = 0; c < numColumns && (fetch = i + c * numRows) < displayList.size(); ++c) {
                    if (c == numColumns - 1) {
                        completionOutput.append(displayList.get(i + c * numRows).toString());
                        continue;
                    }
                    completionOutput.append(Parser.padRight(maxLength + displayList.get(i + c * numRows).getANSILength(), displayList.get(i + c * numRows).toString()));
                }
                completionOutput.append(Config.getLineSeparator());
            }
        } else {
            for (TerminalString ts : displayList) {
                completionOutput.append(ts.toString()).append("  ");
            }
            completionOutput.append(Config.getLineSeparator());
        }
        return completionOutput.toString();
    }

    public static String formatDisplayCompactListTerminalString(List<TerminalString> displayList, int termWidth) {
        int numRows;
        if (displayList == null || displayList.size() < 1) {
            return "";
        }
        if (termWidth < 1) {
            termWidth = 80;
        }
        for (numRows = 1; !Parser.canDisplayColumns(displayList, numRows, termWidth) && numRows < displayList.size(); ++numRows) {
        }
        int numColumns = displayList.size() / numRows;
        if (displayList.size() % numRows > 0) {
            ++numColumns;
        }
        int[] columnsSizes = Parser.calculateColumnSizes(displayList, numColumns, numRows, termWidth);
        StringBuilder stringOutput = new StringBuilder();
        for (int i = 0; i < numRows; ++i) {
            for (int c = 0; c < numColumns; ++c) {
                int fetch = i + c * numRows;
                int nextFetch = i + (c + 1) * numRows;
                if (fetch >= displayList.size()) break;
                if (nextFetch < displayList.size()) {
                    stringOutput.append(Parser.padRight(columnsSizes[c] + displayList.get(i + c * numRows).getANSILength(), displayList.get(i + c * numRows).toString()));
                    continue;
                }
                stringOutput.append(displayList.get(i + c * numRows).toString());
            }
            stringOutput.append(Config.getLineSeparator());
        }
        return stringOutput.toString();
    }

    private static boolean canDisplayColumns(List<TerminalString> displayList, int numRows, int terminalWidth) {
        int numColumns = displayList.size() / numRows;
        if (displayList.size() % numRows > 0) {
            ++numColumns;
        }
        int[] columnSizes = Parser.calculateColumnSizes(displayList, numColumns, numRows, terminalWidth);
        int totalSize = 0;
        for (int columnSize : columnSizes) {
            totalSize += columnSize;
        }
        return totalSize <= terminalWidth;
    }

    private static int[] calculateColumnSizes(List<TerminalString> displayList, int numColumns, int numRows, int termWidth) {
        int[] columnSizes = new int[numColumns];
        for (int i = 0; i < displayList.size(); ++i) {
            int columnIndex = i / numRows % numColumns;
            int stringSize = displayList.get(i).getCharacters().length() + 2;
            if (columnSizes[columnIndex] >= stringSize || stringSize > termWidth) continue;
            columnSizes[columnIndex] = stringSize;
        }
        return columnSizes;
    }

    public static String padRight(int n, String s) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(int n, String s) {
        return String.format("%1$" + n + "s", s);
    }

    public static List<String> splitBySizeKeepWords(String words, int size) {
        ArrayList<String> out = new ArrayList<String>();
        if (words.length() <= size) {
            out.add(words);
            return out;
        }
        while (words.length() > size) {
            int i = words.lastIndexOf(32, size);
            if (i > 0) {
                out.add(words.substring(0, i));
                words = words.substring(i + 1);
                continue;
            }
            out.add(words);
            break;
        }
        if (words.length() > 0) {
            out.add(words);
        }
        return out;
    }

    public static String trimOptionName(String word) {
        if (word.startsWith("--")) {
            return word.substring(2);
        }
        if (word.startsWith("-")) {
            return word.substring(1);
        }
        return word;
    }

    public static boolean findIfWordEndWithSpace(String word) {
        return !word.isEmpty() && word.endsWith(SPACE) && !word.endsWith(spaceEscapedMatcher);
    }

    public static String findStartsWithOperation(List<? extends CompleteOperation> coList) {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (CompleteOperation completeOperation : coList) {
            String s = Parser.findStartsWith(completeOperation.getFormattedCompletionCandidates());
            if (s.length() > 0) {
                tmpList.add(s);
                continue;
            }
            return "";
        }
        return Parser.findStartsWith(tmpList);
    }

    public static String findStartsWith(List<String> completionList) {
        StringBuilder builder = new StringBuilder();
        for (String completion : completionList) {
            while (builder.length() < completion.length() && Parser.startsWith(completion.substring(0, builder.length() + 1), completionList)) {
                builder.append(completion.charAt(builder.length()));
            }
        }
        return builder.toString();
    }

    private static boolean startsWith(String criteria, List<String> completionList) {
        for (String completion : completionList) {
            if (completion.startsWith(criteria)) continue;
            return false;
        }
        return true;
    }

    public static String findStartsWithTerminalString(List<TerminalString> completionList) {
        StringBuilder builder = new StringBuilder();
        for (TerminalString completion : completionList) {
            while (builder.length() < completion.getCharacters().length() && Parser.startsWithTerminalString(completion.getCharacters().substring(0, builder.length() + 1), completionList)) {
                builder.append(completion.getCharacters().charAt(builder.length()));
            }
        }
        return builder.toString();
    }

    private static boolean startsWithTerminalString(String criteria, List<TerminalString> completionList) {
        for (TerminalString completion : completionList) {
            if (completion.getCharacters().startsWith(criteria)) continue;
            return false;
        }
        return true;
    }

    public static String findWordClosestToCursor(String text, int cursor) {
        boolean startOutsideText = false;
        if (cursor >= text.length()) {
            cursor = text.length() - 1;
            startOutsideText = true;
        }
        if (cursor < 0 || text.trim().length() == 0) {
            return "";
        }
        boolean foundBackslash = false;
        if (text.contains(SPACE)) {
            int end;
            int start;
            if (text.charAt(cursor) == ' ') {
                if (startOutsideText) {
                    return "";
                }
                if (cursor > 0) {
                    if (text.charAt(cursor - 1) == ' ') {
                        return "";
                    }
                    --cursor;
                }
            }
            boolean space = false;
            for (start = cursor; start > 0; --start) {
                if (space) {
                    if (text.charAt(start) == '\\') {
                        space = false;
                        foundBackslash = true;
                    } else {
                        start += 2;
                        break;
                    }
                }
                if (!Character.isSpaceChar(text.charAt(start))) continue;
                space = true;
            }
            boolean back = false;
            for (end = cursor; end < text.length(); ++end) {
                if (text.charAt(end) == '\\') {
                    back = true;
                    foundBackslash = true;
                    continue;
                }
                if (back) {
                    if (!Character.isSpaceChar(text.charAt(end))) continue;
                    back = false;
                    continue;
                }
                if (Character.isSpaceChar(text.charAt(end))) break;
            }
            if (foundBackslash) {
                return Parser.switchEscapedSpacesToSpacesInWord(text.substring(start, end));
            }
            return text.substring(start, end);
        }
        return text.trim();
    }

    public static String findCurrentWordFromCursor(String text, int cursor) {
        if (text.length() <= cursor + 1) {
            if (text.contains(SPACE)) {
                if (Parser.doWordContainEscapedSpace(text)) {
                    if (Parser.doWordContainOnlyEscapedSpace(text)) {
                        return Parser.switchEscapedSpacesToSpacesInWord(text);
                    }
                    return Parser.switchEscapedSpacesToSpacesInWord(Parser.findEscapedSpaceWordCloseToEnd(text));
                }
                if (text.lastIndexOf(SPACE) >= cursor) {
                    return text.substring(text.substring(0, cursor).lastIndexOf(SPACE)).trim();
                }
                return text.substring(text.lastIndexOf(SPACE)).trim();
            }
            return text.trim();
        }
        String rest = text.length() > cursor + 1 ? text.substring(0, cursor + 1) : text;
        if (Parser.doWordContainOnlyEscapedSpace(rest)) {
            if (cursor > 1 && text.charAt(cursor) == ' ' && text.charAt(cursor - 1) == ' ') {
                return "";
            }
            return Parser.switchEscapedSpacesToSpacesInWord(rest);
        }
        if (cursor > 1 && text.charAt(cursor) == ' ' && text.charAt(cursor - 1) == ' ') {
            return "";
        }
        if (rest.trim().contains(SPACE)) {
            return rest.substring(rest.trim().lastIndexOf(SPACE)).trim();
        }
        return rest.trim();
    }

    public static String findEscapedSpaceWordCloseToEnd(String text) {
        int index;
        String originalText = text;
        while ((index = text.lastIndexOf(SPACE)) > -1) {
            if (index > 0 && text.charAt(index - 1) == '\\') {
                text = text.substring(0, index - 1);
                continue;
            }
            return originalText.substring(index + 1);
        }
        return originalText;
    }

    public static boolean doesStringContainOpenQuote(String text) {
        boolean doubleQuote = false;
        boolean singleQuote = false;
        boolean escapedByBackSlash = false;
        if (commentPattern.matcher(text).find()) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\\' || escapedByBackSlash) {
                escapedByBackSlash = !escapedByBackSlash;
                continue;
            }
            if (text.charAt(i) == '\'') {
                if (doubleQuote) continue;
                singleQuote = !singleQuote;
                continue;
            }
            if (text.charAt(i) != '\"' || singleQuote) continue;
            doubleQuote = !doubleQuote;
        }
        return doubleQuote || singleQuote;
    }

    public static boolean doWordContainOnlyEscapedSpace(String word) {
        return Parser.findAllOccurrences(word, spaceEscapedMatcher) == Parser.findAllOccurrences(word, SPACE);
    }

    public static boolean doWordContainEscapedSpace(String word) {
        return spaceEscapedPattern.matcher(word).find();
    }

    public static int findNumberOfSpacesInWord(String word) {
        int count = 0;
        for (int i = 0; i < word.length(); ++i) {
            if (word.charAt(i) != ' ' || i != 0 && word.charAt(i - 1) == '\\') continue;
            ++count;
        }
        return count;
    }

    public static int findAllOccurrences(String word, String pattern) {
        int count = 0;
        while (word.contains(pattern)) {
            ++count;
            word = word.substring(word.indexOf(pattern) + pattern.length());
        }
        return count;
    }

    public static List<String> switchEscapedSpacesToSpacesInList(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>(list.size());
        for (String s : list) {
            newList.add(Parser.switchEscapedSpacesToSpacesInWord(s));
        }
        return newList;
    }

    public static void switchEscapedSpacesToSpacesInTerminalStringList(List<TerminalString> list) {
        for (TerminalString ts : list) {
            ts.setCharacters(Parser.switchEscapedSpacesToSpacesInWord(ts.getCharacters()));
        }
    }

    public static String switchSpacesToEscapedSpacesInWord(String word) {
        return spacePattern.matcher(word).replaceAll("\\\\ ");
    }

    public static String switchEscapedSpacesToSpacesInWord(String word) {
        return spaceEscapedPattern.matcher(word).replaceAll(SPACE);
    }

    public static String trim(String buffer) {
        int i;
        int count = 0;
        for (i = 0; i < buffer.length() && buffer.charAt(i) == ' '; ++i) {
            ++count;
        }
        if (count > 0) {
            buffer = buffer.substring(count);
        }
        count = buffer.length();
        for (i = buffer.length() - 1; i > 0 && buffer.charAt(i) == ' ' && buffer.charAt(i - 1) != '\\'; --i) {
            --count;
        }
        if (count != buffer.length()) {
            buffer = buffer.substring(0, count);
        }
        return buffer;
    }

    public static String trimInFront(String buffer) {
        int count = 0;
        for (int i = 0; i < buffer.length() && buffer.charAt(i) == ' '; ++i) {
            ++count;
        }
        if (count > 0) {
            return buffer.substring(count);
        }
        return buffer;
    }

    public static String findFirstWord(String buffer) {
        if (buffer.indexOf(32) < 0) {
            return buffer;
        }
        int index = (buffer = Parser.trim(buffer)).indexOf(32);
        if (index > 0) {
            return buffer.substring(0, index);
        }
        return buffer;
    }

    public static boolean containsNonEscapedDollar(String buffer) {
        int startIndex = 0;
        while ((startIndex = buffer.indexOf(36, startIndex)) > -1) {
            if (startIndex == 0) {
                return true;
            }
            if (buffer.charAt(startIndex - 1) != '\\') {
                return true;
            }
            ++startIndex;
        }
        return false;
    }

    public static String stripAwayAnsiCodes(String text) {
        return ansiPattern.matcher(text).replaceAll("");
    }

    public static int[] toCodePoints(String s) {
        return s.codePoints().toArray();
    }

    public static String fromCodePoints(int[] input) {
        return new String(input, 0, input.length);
    }

    public static boolean isTrimmedArrayEmpty(int[] input) {
        for (int i : input) {
            if (i == 32) continue;
            return false;
        }
        return true;
    }

    public static int arrayIndexOf(int[] source, int[] target) {
        return Parser.arrayIndexOf(source, 0, source.length, target, 0, target.length, 0);
    }

    public static int arrayIndexOf(int[] source, int sourceOffset, int sourceCount, int[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static boolean arrayContains(int[] source, int[] target) {
        return Parser.arrayIndexOf(source, target) > -1;
    }
}

