/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class TestBase {
    protected static final int[] CTRL_A_KEY = new int[]{TestBase.ctrl('A')};
    protected static final int[] CTRL_C_KEY = new int[]{TestBase.ctrl('C')};
    protected static final int[] CTRL_D_KEY = new int[]{TestBase.ctrl('D')};
    protected static final int[] CTRL_E_KEY = new int[]{TestBase.ctrl('E')};
    protected static final int[] UP_KEY = new int[]{27, 91, 65};
    protected static final int[] DOWN_KEY = new int[]{27, 91, 66};
    protected static final int[] FORWARD_KEY = new int[]{27, 91, 67};
    protected static final int[] BACKWARD_KEY = new int[]{27, 91, 68};
    protected static final int[] BACKWARD_DELETE_KEY = new int[]{8};
    protected static final int[] KILL_LINE = new int[]{TestBase.ctrl('K')};
    protected static final int[] META_BACKWARD_DELETE_KEY = new int[]{27, 8};
    private volatile Throwable throwable;
    private CountDownLatch latch;
    private Exception testCompleteCalled;
    private boolean awaitCalled;

    private static int ctrl(char c) {
        return c - 64;
    }

    protected void testComplete() {
        if (this.testCompleteCalled != null) {
            throw new IllegalStateException("testComplete() already invoked", this.testCompleteCalled);
        }
        this.testCompleteCalled = new Exception();
        this.latch.countDown();
    }

    public static AssertionError failure(String msg) {
        return new AssertionError((Object)msg);
    }

    public static AssertionError failure(String msg, Throwable cause) {
        AssertionError afe = new AssertionError((Object)msg);
        ((Throwable)((Object)afe)).initCause(cause);
        return afe;
    }

    public static AssertionError failure(Throwable cause) {
        if (cause instanceof AssertionError) {
            return (AssertionError)((Object)cause);
        }
        AssertionError ae = new AssertionError();
        ((Throwable)((Object)ae)).initCause(cause);
        return ae;
    }

    protected void await(CountDownLatch latch) {
        try {
            this.assertTrue(latch.await(10L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            throw TestBase.failure(e);
        }
    }

    protected void await() {
        boolean ok;
        if (this.awaitCalled) {
            throw new IllegalStateException("await() already invoked");
        }
        try {
            this.awaitCalled = true;
            ok = this.latch.await(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw TestBase.failure("Test thread was interrupted", e);
        }
        if (!ok) {
            throw TestBase.failure("Test timed out");
        }
        if (this.throwable != null) {
            throw TestBase.failure(this.throwable);
        }
    }

    private void handleThrowable(Throwable t) {
        this.throwable = t;
        this.latch.countDown();
        if (t instanceof AssertionError) {
            throw (AssertionError)((Object)t);
        }
    }

    public void assertNull(Object object) {
        try {
            Assert.assertNull((Object)object);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    public <T> T assertNotNull(T object) {
        try {
            Assert.assertNotNull(object);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
        return object;
    }

    public void fail(Throwable message) {
        try {
            Assert.fail((String)message.getMessage());
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    public void fail(String message) {
        try {
            Assert.fail((String)message);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    public void assertTrue(boolean condition) {
        try {
            Assert.assertTrue((boolean)condition);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    public void assertTrue(String msg, boolean condition) {
        try {
            Assert.assertTrue((String)msg, (boolean)condition);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    public void assertFalse(boolean condition) {
        try {
            Assert.assertFalse((boolean)condition);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    public void assertEquals(Object expected, Object actual) {
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    public void assertEquals(int[] expected, int[] actual) {
        try {
            Assert.assertTrue((String)("Was expecting " + Arrays.toString(expected) + " to be equals to " + Arrays.toString(actual)), (boolean)Arrays.equals(expected, actual));
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    public void awaitLatch(CountDownLatch latch) throws InterruptedException {
        this.assertTrue(latch.await(10L, TimeUnit.SECONDS));
    }

    @Before
    public void beforeTest() {
        this.latch = new CountDownLatch(1);
        this.throwable = null;
        this.testCompleteCalled = null;
        this.awaitCalled = false;
    }

    @After
    public void afterTest() {
        if (this.testCompleteCalled == null && !this.awaitCalled && this.throwable != null) {
            throw new IllegalStateException("You either forget to call testComplete() or forgot to await() for an asynchronous test");
        }
    }

    public int[] toCodePoints(String s) {
        return s.codePoints().toArray();
    }

    public String fromCodePoints(int[] input) {
        return new String(input, 0, input.length);
    }

    public void appendCodePoints(int[] codePoints, StringBuilder sb) {
        this.consumeTo(codePoints, sb::appendCodePoint);
    }

    public void consumeTo(int[] i, IntConsumer consumer) {
        for (int codePoint : i) {
            consumer.accept(codePoint);
        }
    }
}

