/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aesh.io.Decoder;
import org.aesh.io.Encoder;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Device;
import org.aesh.terminal.EventDecoder;
import org.aesh.terminal.ssh.SSHAttributesBuilder;
import org.aesh.terminal.ssh.SSHDevice;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.tty.TtyOutputMode;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.AsyncCommand;
import org.apache.sshd.server.ChannelSessionAware;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;

public class TtyCommand
implements AsyncCommand,
ChannelDataReceiver,
ChannelSessionAware {
    private static final Pattern LC_PATTERN = Pattern.compile("(?:\\p{Alpha}{2}_\\p{Alpha}{2}\\.)?([^@]+)(?:@.+)?");
    private final Consumer<Connection> handler;
    private final Charset defaultCharset;
    private Charset charset;
    private EventDecoder eventDecoder;
    private Decoder decoder;
    private Consumer<int[]> stdout;
    private Consumer<byte[]> out;
    private Size size = null;
    private Consumer<Size> sizeHandler;
    private Consumer<Void> closeHandler;
    protected ChannelSession session;
    private final AtomicBoolean closed = new AtomicBoolean();
    private ExitCallback exitCallback;
    private Connection conn;
    private IoOutputStream ioOut;
    private long lastAccessedTime = System.currentTimeMillis();
    private Device device;
    private IoWriteFuture writeFuture;
    private Attributes attributes;

    public TtyCommand(Charset defaultCharset, Consumer<Connection> handler) {
        this.handler = handler;
        this.defaultCharset = defaultCharset;
    }

    public int data(ChannelSession channel, byte[] buf, int start, int len) throws IOException {
        if (this.decoder != null) {
            this.lastAccessedTime = System.currentTimeMillis();
            this.decoder.write(buf, start, len);
        }
        return len;
    }

    public void setChannelSession(ChannelSession session) {
        this.session = session;
    }

    public void setInputStream(InputStream in) {
    }

    public void setOutputStream(OutputStream out) {
    }

    public void setErrorStream(OutputStream err) {
    }

    public void setIoInputStream(IoInputStream in) {
    }

    public void setIoOutputStream(IoOutputStream out) {
        this.ioOut = out;
        this.out = bytes -> {
            if (this.writeFuture == null) {
                this.writeFuture = out.write((Buffer)new ByteArrayBuffer(bytes));
            } else if (this.writeFuture.isWritten()) {
                this.writeFuture = out.write((Buffer)new ByteArrayBuffer(bytes));
            } else {
                try {
                    this.writeFuture.await();
                    this.writeFuture = out.write((Buffer)new ByteArrayBuffer(bytes));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public void setIoErrorStream(IoOutputStream err) {
    }

    public void setExitCallback(ExitCallback callback) {
        this.exitCallback = callback;
    }

    public void start(Environment env) throws IOException {
        String lcctype = (String)env.getEnv().get("LC_CTYPE");
        if (lcctype != null) {
            this.charset = TtyCommand.parseCharset(lcctype);
        }
        if (this.charset == null) {
            this.charset = this.defaultCharset;
        }
        env.addSignalListener(signal -> this.updateSize(env), EnumSet.of(org.apache.sshd.server.Signal.WINCH));
        this.updateSize(env);
        int vintr = this.getControlChar(env, PtyMode.VINTR, 3);
        int veof = this.getControlChar(env, PtyMode.VEOF, 4);
        int vsusp = this.getControlChar(env, PtyMode.VSUSP, 26);
        this.device = new SSHDevice((String)env.getEnv().get("TERM"));
        this.attributes = SSHAttributesBuilder.builder().environment(env).build();
        this.eventDecoder = new EventDecoder(this.attributes);
        this.decoder = new Decoder(512, this.charset, (Consumer)this.eventDecoder);
        this.stdout = new TtyOutputMode((Consumer)new Encoder(this.charset, this.out));
        this.conn = new SSHConnection();
        this.session.setDataReceiver((ChannelDataReceiver)this);
        this.handler.accept(this.conn);
    }

    private int getControlChar(Environment env, PtyMode key, int def) {
        Integer controlChar = (Integer)env.getPtyModes().get(key);
        return controlChar != null ? controlChar : def;
    }

    public void updateSize(Environment env) {
        String columns = (String)env.getEnv().get("COLUMNS");
        String lines = (String)env.getEnv().get("LINES");
        if (lines != null && columns != null) {
            Size size;
            try {
                int width = Integer.parseInt(columns);
                int height = Integer.parseInt(lines);
                size = new Size(width, height);
            }
            catch (Exception ignore) {
                size = null;
            }
            if (size != null) {
                this.size = size;
                if (this.sizeHandler != null) {
                    this.sizeHandler.accept(size);
                }
            }
        }
    }

    public void close() throws IOException {
        this.ioOut.close(false).addListener(future -> {
            this.exitCallback.onExit(0);
            if (this.closed.compareAndSet(false, true) && this.closeHandler != null) {
                this.closeHandler.accept(null);
            }
        });
    }

    public void destroy() {
    }

    protected void execute(Runnable task) {
        this.session.getSession().getFactoryManager().getScheduledExecutorService().execute(task);
    }

    protected void schedule(Runnable task, long delay, TimeUnit unit) {
        this.session.getSession().getFactoryManager().getScheduledExecutorService().schedule(task, delay, unit);
    }

    private static Charset parseCharset(String value) {
        Matcher matcher = LC_PATTERN.matcher(value);
        if (matcher.matches()) {
            try {
                return Charset.forName(matcher.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private class SSHConnection
    implements Connection {
        private SSHConnection() {
        }

        public Charset inputEncoding() {
            return TtyCommand.this.charset;
        }

        public Charset outputEncoding() {
            return TtyCommand.this.charset;
        }

        public long lastAccessedTime() {
            return TtyCommand.this.lastAccessedTime;
        }

        public Device device() {
            return TtyCommand.this.device;
        }

        public Consumer<int[]> getStdinHandler() {
            return TtyCommand.this.eventDecoder.getInputHandler();
        }

        public void setStdinHandler(Consumer<int[]> handler) {
            TtyCommand.this.eventDecoder.setInputHandler(handler);
        }

        public Size size() {
            return TtyCommand.this.size;
        }

        public Consumer<Size> getSizeHandler() {
            return TtyCommand.this.sizeHandler;
        }

        public void setSizeHandler(Consumer<Size> handler) {
            TtyCommand.this.sizeHandler = handler;
        }

        public Consumer<Signal> getSignalHandler() {
            return TtyCommand.this.eventDecoder.getSignalHandler();
        }

        public void setSignalHandler(Consumer<Signal> handler) {
            TtyCommand.this.eventDecoder.setSignalHandler(handler);
        }

        public Consumer<int[]> stdoutHandler() {
            return TtyCommand.this.stdout;
        }

        public void setCloseHandler(Consumer<Void> handler) {
            TtyCommand.this.closeHandler = handler;
        }

        public Consumer<Void> getCloseHandler() {
            return TtyCommand.this.closeHandler;
        }

        public void close() {
            try {
                TtyCommand.this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void openBlocking() {
        }

        public void openNonBlocking() {
        }

        public boolean put(Capability capability, Object ... params) {
            return false;
        }

        public Attributes getAttributes() {
            return TtyCommand.this.attributes;
        }

        public void setAttributes(Attributes attr) {
        }
    }
}

