/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.io.IOException;
import org.aesh.readline.Buffer;
import org.aesh.readline.Prompt;
import org.aesh.readline.cursor.CursorLocation;
import org.aesh.readline.cursor.CursorLocator;
import org.aesh.readline.cursor.Line;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Connection;
import org.junit.Assert;
import org.junit.Test;

public class CursorLocatorTest {
    private static final String PROMPT = "test> ";
    private static final String MULTI_LINE_PROMPT = "> ";
    private static final int WIDTH = 80;

    @Test
    public void test() {
        Buffer buffer = new Buffer(new Prompt(PROMPT));
        CursorLocatorTest.check(buffer, 0, 0, PROMPT.length(), 80);
        buffer = new Buffer(new Prompt(PROMPT));
        CursorLocator locator = buffer.getCursorLocator();
        CursorLocation loc = locator.locate(10, 80);
        Assert.assertTrue((loc == null ? 1 : 0) != 0);
        buffer = new Buffer(new Prompt(PROMPT));
        String cmd = "cmd --opt1";
        int offset = 3;
        buffer.insert(c -> {}, cmd, 80);
        CursorLocatorTest.check(buffer, offset, 0, PROMPT.length() + offset, 80);
    }

    @Test
    public void testWrapping() {
        Buffer buffer = new Buffer(new Prompt(PROMPT));
        String cmd = "cmd --opt1";
        int width = PROMPT.length() + cmd.length() / 2;
        int offset = cmd.length() / 2;
        buffer.insert(c -> {}, cmd, width);
        CursorLocatorTest.check(buffer, offset, 1, 0, width);
        CursorLocatorTest.checkCursor(buffer, 1, offset, width);
        buffer = new Buffer(new Prompt(PROMPT));
        cmd = "cmd --opt1";
        width = PROMPT.length() + cmd.length() / 2;
        offset = cmd.length() / 2 - 1;
        buffer.insert(c -> {}, cmd, width);
        CursorLocatorTest.check(buffer, offset, 0, width - 1, width);
        buffer = new Buffer(new Prompt(PROMPT));
        cmd = "cmd --opt1";
        width = PROMPT.length() + cmd.length();
        offset = cmd.length() - 1;
        buffer.insert(c -> {}, cmd, width);
        CursorLocatorTest.check(buffer, offset, 0, offset + PROMPT.length(), width);
        CursorLocatorTest.checkCursor(buffer, 1, 0, width);
    }

    @Test
    public void testMultiline() {
        Buffer buffer = new Buffer(new Prompt(PROMPT));
        String cmd = "cmd --opt1\\";
        buffer.insert(c -> {}, cmd, 80);
        buffer.setMultiLine(true);
        buffer.updateMultiLineBuffer();
        String cmd2 = "--opt2";
        buffer.insert(c -> {}, cmd2, 80);
        int offset = cmd.length() - 1 + cmd2.length();
        CursorLocatorTest.check(buffer, offset, 1, cmd2.length() + MULTI_LINE_PROMPT.length(), 80);
        CursorLocatorTest.checkCursor(buffer, 1, cmd2.length() + MULTI_LINE_PROMPT.length(), 80);
        buffer = new Buffer(new Prompt(PROMPT));
        cmd = "cmd --opt1";
        buffer.insert(c -> {}, cmd + "\\", 80);
        buffer.setMultiLine(true);
        buffer.updateMultiLineBuffer();
        int offset2 = cmd.length() - 1;
        CursorLocatorTest.check(buffer, offset2, 0, cmd.length() + PROMPT.length() - 1, 80);
        CursorLocatorTest.checkCursor(buffer, 1, MULTI_LINE_PROMPT.length(), 80);
        buffer = new Buffer(new Prompt(PROMPT));
        cmd = "cmd --opt1 --opt2 --opt3\\";
        int width = PROMPT.length() + cmd.length() / 2;
        buffer.insert(c -> {}, cmd, width);
        buffer.setMultiLine(true);
        buffer.updateMultiLineBuffer();
        String cmd22 = "--opt4";
        buffer.insert(c -> {}, cmd22, width);
        int offset3 = cmd.length() - 1 + cmd22.length();
        CursorLocatorTest.check(buffer, offset3, 2, cmd22.length() + MULTI_LINE_PROMPT.length(), width);
    }

    @Test
    public void lineTest() throws IOException {
        TerminalConnection connection = new TerminalConnection();
        Buffer buffer = new Buffer(new Prompt(PROMPT));
        String cmd1 = "cmd --opt1 --opt2 ";
        String cmd2 = "--opt3 --opt4";
        String cmd = cmd1 + cmd2;
        buffer.insert(c -> {}, cmd1 + "\\", 80);
        buffer.setMultiLine(true);
        buffer.updateMultiLineBuffer();
        buffer.insert(c -> {}, cmd2, 80);
        Line line = new Line(buffer, (Connection)connection, 80);
        String s = line.getLineToCursor();
        Assert.assertEquals((Object)cmd, (Object)s);
        Assert.assertFalse((line.getCursorLocator() == null ? 1 : 0) != 0);
        Assert.assertEquals((long)buffer.multiCursor(), (long)s.length());
        line.newCursorTransactionBuilder().move(10).build().run();
        Assert.assertEquals((long)buffer.multiCursor(), (long)s.length());
        line.newCursorTransactionBuilder().moveBackward(10).build().run();
        Assert.assertEquals((long)buffer.multiCursor(), (long)s.length());
        line.newCursorTransactionBuilder().moveForward(10).build().run();
        Assert.assertEquals((long)buffer.multiCursor(), (long)s.length());
        line.newCursorTransactionBuilder().moveDown(10).build().run();
        Assert.assertEquals((long)buffer.multiCursor(), (long)s.length());
        line.newCursorTransactionBuilder().moveUp(10).build().run();
        Assert.assertEquals((long)buffer.multiCursor(), (long)s.length());
        line.newCursorTransactionBuilder().colorize(10, Color.DEFAULT, Color.DEFAULT, true).build().run();
        Assert.assertEquals((long)buffer.multiCursor(), (long)s.length());
    }

    private static void checkCursor(Buffer buffer, int row, int col, int width) {
        int c = buffer.multiCursor();
        CursorLocatorTest.check(buffer, c, row, col, width);
    }

    private static void check(Buffer buffer, int offset, int row, int col, int width) {
        CursorLocation cursorLoc = buffer.getCursorLocator().locate(offset, width);
        Assert.assertTrue((String)("Invalid column " + cursorLoc.getColumn() + ". Expected " + col), (cursorLoc.getColumn() == col ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid row " + cursorLoc.getRow() + ". Expected " + row), (cursorLoc.getRow() == row ? 1 : 0) != 0);
    }
}

