/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.terminal.impl.LineDisciplineTerminal;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Terminal;

public class TestTerminal {
    private Readline readline;
    private ByteArrayOutputStream byteArrayOutputStream;
    private TerminalConnection connection;
    private LineDisciplineTerminal terminal;
    private List<String> output;
    private Prompt prompt;

    public TestTerminal() {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.terminal = new LineDisciplineTerminal("aesh-test", "term", (OutputStream)this.byteArrayOutputStream);
            this.connection = new TerminalConnection((Terminal)this.terminal);
            this.output = new ArrayList<String>();
            this.prompt = new Prompt(": ");
            this.readline = new Readline();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(String input) {
        input.codePoints().forEach(value -> {
            try {
                this.terminal.processInputBytes(input.getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void write(int in) {
        try {
            this.terminal.processInputByte(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(int[] in) {
        try {
            for (int i : in) {
                this.terminal.processInputByte(i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void read(Consumer<String> handler) {
        this.readline.readline((Connection)this.connection, this.prompt, handler);
    }

    public void start() {
        this.connection.openBlocking();
    }

    public String getLine() {
        if (this.output.size() > 0) {
            return this.output.remove(0);
        }
        return null;
    }

    public String getOutput() {
        return this.byteArrayOutputStream.toString();
    }

    public void close() {
        try {
            this.terminal.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Terminal getTerminal() {
        return this.terminal;
    }
}

