/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.aesh.terminal.http.server.TaskStatusUpdateEvent;
import org.aesh.terminal.http.utils.ObjectWrapper;
import org.aesh.terminal.http.utils.Wait;

public class Client {
    public static final String WEB_SOCKET_TERMINAL_PATH = "/socket/term";
    public static final String WEB_SOCKET_LISTENER_PATH = "/socket/process-status-updates";
    private static final Logger LOGGER = Logger.getLogger(Client.class.getName());
    ProgramaticClientEndpoint endpoint = new ProgramaticClientEndpoint();
    private Consumer<Session> onOpenConsumer;
    private Consumer<String> onStringMessageConsumer;
    private Consumer<byte[]> onBinaryMessageConsumer;
    private Consumer<CloseReason> onCloseConsumer;
    private Consumer<Throwable> onErrorConsumer;

    public Endpoint connect(String websocketUrl) throws Exception {
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().build();
        ContainerProvider.getWebSocketContainer().connectToServer((Endpoint)this.endpoint, clientEndpointConfig, new URI(websocketUrl));
        return this.endpoint;
    }

    public void close() throws Exception {
        LOGGER.log(Level.INFO, "Client is closing connection.");
        this.endpoint.session.close();
    }

    public void onOpen(Consumer<Session> onOpen) {
        this.onOpenConsumer = onOpen;
    }

    public void onStringMessage(Consumer<String> onStringMessage) {
        this.onStringMessageConsumer = onStringMessage;
    }

    public void onBinaryMessage(Consumer<byte[]> onBinaryMessage) {
        this.onBinaryMessageConsumer = onBinaryMessage;
    }

    public void onClose(Consumer<CloseReason> onClose) {
        this.onCloseConsumer = onClose;
    }

    public void onError(Consumer<Throwable> onError) {
        this.onErrorConsumer = onError;
    }

    public RemoteEndpoint.Basic getRemoteEndpoint() {
        return this.endpoint.session.getBasicRemote();
    }

    public static Client initializeDefault() {
        Client client = new Client();
        Consumer<Session> onOpen = session -> LOGGER.info("Client connection opened.");
        Consumer<CloseReason> onClose = closeReason -> LOGGER.info("Client connection closed. " + closeReason);
        client.onOpen(onOpen);
        client.onClose(onClose);
        return client;
    }

    public static Client connectStatusListenerClient(String webSocketUrl, Consumer<TaskStatusUpdateEvent> onStatusUpdate) {
        Client client = Client.initializeDefault();
        Consumer<String> responseConsumer = text -> {
            LOGGER.log(Level.FINE, "Decoding response: {}", text);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = null;
            try {
                jsonObject = mapper.readTree(text);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Cannot read JSON string: " + text, e);
            }
            try {
                TaskStatusUpdateEvent taskStatusUpdateEvent = TaskStatusUpdateEvent.fromJson(jsonObject.get("event").toString());
                onStatusUpdate.accept(taskStatusUpdateEvent);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Cannot deserialize TaskStatusUpdateEvent.", e);
            }
        };
        client.onStringMessage(responseConsumer);
        client.onClose(closeReason -> {});
        try {
            client.connect(webSocketUrl + "/");
        }
        catch (Exception e) {
            throw new AssertionError("Failed to connect to remote client.", e);
        }
        return client;
    }

    public static Client connectCommandExecutingClient(String webSocketUrl, Optional<Consumer<String>> responseDataConsumer) throws InterruptedException, TimeoutException {
        ObjectWrapper<Boolean> connected = new ObjectWrapper<Boolean>(false);
        Client client = Client.initializeDefault();
        Consumer<byte[]> responseConsumer = bytes -> {
            String responseData = new String((byte[])bytes);
            if ("% ".equals(responseData)) {
                connected.set(true);
            } else {
                responseDataConsumer.ifPresent(rdc -> rdc.accept(responseData));
            }
        };
        client.onBinaryMessage(responseConsumer);
        client.onClose(closeReason -> {});
        try {
            client.connect(webSocketUrl + "/");
        }
        catch (Exception e) {
            throw new AssertionError("Failed to connect to remote client.", e);
        }
        Wait.forCondition(() -> (Boolean)connected.get(), 5L, ChronoUnit.SECONDS, "Client was not connected within given timeout.");
        return client;
    }

    public static void executeRemoteCommand(Client client, String command) {
        LOGGER.info("Executing remote command ...");
        RemoteEndpoint.Basic remoteEndpoint = client.getRemoteEndpoint();
        String data = "{\"action\":\"read\",\"data\":\"" + command + "\\r\\n\"}";
        try {
            remoteEndpoint.sendBinary(ByteBuffer.wrap(data.getBytes()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class ProgramaticClientEndpoint
    extends Endpoint {
        volatile Session session;

        public void onOpen(Session session, EndpointConfig config) {
            LOGGER.log(Level.FINE, "Client received open.");
            this.session = session;
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    LOGGER.log(Level.FINEST, "Client received text MESSAGE: {}", message);
                    if (Client.this.onStringMessageConsumer != null) {
                        Client.this.onStringMessageConsumer.accept(message);
                    }
                }
            });
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<byte[]>(){

                public void onMessage(byte[] bytes) {
                    LOGGER.log(Level.FINEST, "Client received binary MESSAGE: {}", new String(bytes));
                    if (Client.this.onBinaryMessageConsumer != null) {
                        Client.this.onBinaryMessageConsumer.accept(bytes);
                    }
                }
            });
            if (Client.this.onOpenConsumer != null) {
                Client.this.onOpenConsumer.accept(session);
            }
        }

        public void onClose(Session session, CloseReason closeReason) {
            LOGGER.log(Level.SEVERE, "Client received close.");
            Client.this.onCloseConsumer.accept(closeReason);
        }

        public void onError(Session session, Throwable thr) {
            if (Client.this.onErrorConsumer != null) {
                Client.this.onErrorConsumer.accept(thr);
            } else {
                LOGGER.log(Level.SEVERE, "No error handler defined. Received error was: ", thr);
            }
        }
    }
}

