/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.aesh.terminal.Connection;
import org.aesh.terminal.http.HttpTtyConnection;
import org.aesh.terminal.http.netty.HttpRequestHandler;

public class TtyWebSocketFrameHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private final ChannelGroup group;
    private final Consumer<Connection> handler;
    private ChannelHandlerContext context;
    private HttpTtyConnection conn;

    public TtyWebSocketFrameHandler(ChannelGroup group, Consumer<Connection> handler) {
        this.group = group;
        this.handler = handler;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.context = ctx;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            ctx.pipeline().remove(HttpRequestHandler.class);
            this.group.add((Object)ctx.channel());
            this.conn = new HttpTtyConnection(){

                @Override
                protected void write(byte[] buffer) {
                    ByteBuf byteBuf = Unpooled.buffer();
                    byteBuf.writeBytes(buffer);
                    TtyWebSocketFrameHandler.this.context.writeAndFlush((Object)new TextWebSocketFrame(byteBuf));
                }

                public void schedule(Runnable task, long delay, TimeUnit unit) {
                    TtyWebSocketFrameHandler.this.context.executor().schedule(task, delay, unit);
                }

                public void execute(Runnable task) {
                    TtyWebSocketFrameHandler.this.context.executor().execute(task);
                }

                public void close() {
                    TtyWebSocketFrameHandler.this.context.close();
                }
            };
            this.handler.accept(this.conn);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Consumer<Void> closeHandler;
        HttpTtyConnection tmp = this.conn;
        this.context = null;
        this.conn = null;
        if (tmp != null && (closeHandler = tmp.getCloseHandler()) != null) {
            closeHandler.accept(null);
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        this.conn.writeToDecoder(msg.text());
    }
}

