/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Device;
import org.aesh.terminal.EventDecoder;
import org.aesh.terminal.io.Decoder;
import org.aesh.terminal.io.Encoder;
import org.aesh.terminal.telnet.Option;
import org.aesh.terminal.telnet.ReadBuffer;
import org.aesh.terminal.telnet.TelnetCharset;
import org.aesh.terminal.telnet.TelnetConnection;
import org.aesh.terminal.telnet.TelnetDevice;
import org.aesh.terminal.telnet.TelnetHandler;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.tty.TtyOutputMode;

public final class TelnetTtyConnection
extends TelnetHandler
implements Connection {
    private final boolean inBinary;
    private final boolean outBinary;
    private boolean receivingBinary;
    private boolean sendingBinary;
    private boolean accepted;
    private Size size;
    private String terminalType;
    private Consumer<Size> sizeHandler;
    private Consumer<Void> closeHandler;
    protected TelnetConnection conn;
    private final Charset charset;
    private final EventDecoder eventDecoder = new EventDecoder(3, 4, 26);
    private final ReadBuffer readBuffer = new ReadBuffer(this::execute);
    private final Decoder decoder = new Decoder(512, TelnetCharset.INSTANCE, (Consumer)this.readBuffer);
    private final Encoder encoder = new Encoder(StandardCharsets.US_ASCII, data -> this.conn.write((byte[])data));
    private final Consumer<int[]> stdout = new TtyOutputMode((Consumer)this.encoder);
    private final Consumer<Connection> handler;
    private long lastAccessedTime = System.currentTimeMillis();
    private Device device;
    private Attributes attributes;

    public TelnetTtyConnection(boolean inBinary, boolean outBinary, Charset charset, Consumer<Connection> handler) {
        this.charset = charset;
        this.inBinary = inBinary;
        this.outBinary = outBinary;
        this.handler = handler;
    }

    public long lastAccessedTime() {
        return this.lastAccessedTime;
    }

    public String terminalType() {
        return this.terminalType;
    }

    public void execute(Runnable task) {
        this.conn.execute(task);
    }

    public void schedule(Runnable task, long delay, TimeUnit unit) {
        this.conn.schedule(task, delay, unit);
    }

    public Charset inputEncoding() {
        return this.inBinary ? this.charset : StandardCharsets.US_ASCII;
    }

    public Charset outputEncoding() {
        return this.outBinary ? this.charset : StandardCharsets.US_ASCII;
    }

    public boolean supportsAnsi() {
        return true;
    }

    @Override
    protected void onSendBinary(boolean binary) {
        this.sendingBinary = binary;
        if (binary) {
            this.encoder.setCharset(this.charset);
        }
        this.checkAccept();
    }

    @Override
    protected void onReceiveBinary(boolean binary) {
        this.receivingBinary = binary;
        if (binary) {
            this.decoder.setCharset(this.charset);
        }
        this.checkAccept();
    }

    @Override
    protected void onData(byte[] data) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.decoder.write(data);
    }

    @Override
    protected void onOpen(TelnetConnection conn) {
        this.conn = conn;
        this.size = new Size(80, 24);
        conn.writeWillOption(Option.ECHO);
        conn.writeWillOption(Option.SGA);
        if (this.inBinary) {
            conn.writeDoOption(Option.BINARY);
        }
        if (this.outBinary) {
            conn.writeWillOption(Option.BINARY);
        }
        conn.writeDoOption(Option.NAWS);
        conn.writeDoOption(Option.TERMINAL_TYPE);
        this.attributes = new Attributes();
        this.checkAccept();
    }

    private void checkAccept() {
        if (!this.accepted && !this.outBinary | (this.outBinary && this.sendingBinary) && !this.inBinary | (this.inBinary && this.receivingBinary)) {
            this.accepted = true;
            this.readBuffer.setReadHandler((Consumer<int[]>)this.eventDecoder);
            this.handler.accept(this);
        }
    }

    @Override
    protected void onTerminalType(String terminalType) {
        this.terminalType = terminalType;
        this.device = new TelnetDevice(terminalType);
    }

    public Size size() {
        return this.size;
    }

    @Override
    protected void onSize(int width, int height) {
        this.size = new Size(width, height);
        if (this.sizeHandler != null) {
            this.sizeHandler.accept(this.size);
        }
    }

    public Device device() {
        if (this.device == null) {
            this.device = new TelnetDevice("vt100");
        }
        return this.device;
    }

    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    public void setSizeHandler(Consumer<Size> handler) {
        this.sizeHandler = handler;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.eventDecoder.getSignalHandler();
    }

    public void setSignalHandler(Consumer<Signal> handler) {
        this.eventDecoder.setSignalHandler(handler);
    }

    public Consumer<int[]> getStdinHandler() {
        return this.eventDecoder.getInputHandler();
    }

    public void setStdinHandler(Consumer<int[]> handler) {
        this.eventDecoder.setInputHandler(handler);
    }

    public Consumer<int[]> stdoutHandler() {
        return this.stdout;
    }

    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    @Override
    protected void onClose() {
        if (this.closeHandler != null) {
            this.closeHandler.accept(null);
        }
    }

    public void close() {
        this.conn.close();
    }

    public void openBlocking() {
    }

    public void openNonBlocking() {
    }

    public boolean put(Capability capability, Object ... params) {
        return false;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attr) {
    }
}

