/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.common;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Functions {
    private static final Logger log = LoggerFactory.getLogger(Functions.class);
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");

    private Functions() {
    }

    public static BigInteger numericStringToBigInteger(String numeric) {
        return Functions.numericStringToBigInteger(numeric, true);
    }

    public static BigInteger numericStringToBigInteger(String numeric, boolean round) {
        BigDecimal decimal;
        try {
            decimal = new BigDecimal(numeric);
        }
        catch (Exception ex) {
            return null;
        }
        if (round) {
            decimal = decimal.setScale(0, 4);
        }
        BigInteger integer = decimal.toBigInteger();
        return integer;
    }

    public static synchronized Date convertFromAgmipDateString(String agmipDate) {
        try {
            return dateFormatter.parse(agmipDate);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static synchronized String convertToAgmipDateString(Date date) {
        if (date != null) {
            return dateFormatter.format(date);
        }
        return null;
    }

    public static synchronized String formatAgmipDateString(String agmipDate, String format) {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(format);
            Date d = dateFormatter.parse(agmipDate);
            return fmt.format(d);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String calcDAP(String date, String pdate) {
        Date d = Functions.convertFromAgmipDateString(date);
        Date p = Functions.convertFromAgmipDateString(pdate);
        if (d == null || p == null) {
            return "";
        }
        return Functions.convertMsToDay(d.getTime() - p.getTime());
    }

    public static String convertMsToDay(long ms) {
        return Functions.divide(ms + "", "86400000", 0);
    }

    public static String dateOffset(String initial, String offset) {
        Date date = Functions.convertFromAgmipDateString(initial);
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        try {
            BigInteger iOffset = new BigInteger(offset);
            cal.add(5, iOffset.intValue());
        }
        catch (Exception ex) {
            return null;
        }
        return Functions.convertToAgmipDateString(cal.getTime());
    }

    public static String yearOffset(String initial, String offset) {
        Date date = Functions.convertFromAgmipDateString(initial);
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        try {
            BigInteger iOffset = new BigInteger(offset);
            cal.add(1, iOffset.intValue());
        }
        catch (Exception ex) {
            return null;
        }
        return Functions.convertToAgmipDateString(cal.getTime());
    }

    public static String numericOffset(String initial, String offset) {
        BigDecimal dOffset;
        BigDecimal number;
        try {
            number = new BigDecimal(initial);
            dOffset = new BigDecimal(offset);
        }
        catch (Exception ex) {
            return null;
        }
        return number.add(dOffset).toString();
    }

    public static String multiply(String f1, String f2) {
        BigDecimal factor2;
        BigDecimal factor1;
        try {
            factor1 = new BigDecimal(f1);
            factor2 = new BigDecimal(f2);
        }
        catch (Exception ex) {
            return null;
        }
        return factor1.multiply(factor2).toString();
    }

    public static String sum(String ... addends) {
        if (addends == null || addends.length == 0) {
            return null;
        }
        try {
            BigDecimal sum = new BigDecimal(addends[0]);
            for (int i = 1; i < addends.length; ++i) {
                sum = sum.add(new BigDecimal(addends[i]));
            }
            return sum.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String substract(String minuend, String ... subtrahends) {
        if (subtrahends == null) {
            return minuend;
        }
        try {
            BigDecimal difference = new BigDecimal(minuend);
            for (int i = 0; i < subtrahends.length; ++i) {
                difference = difference.subtract(new BigDecimal(subtrahends[i]));
            }
            return difference.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String product(String ... factors) {
        if (factors == null || factors.length == 0) {
            return null;
        }
        try {
            BigDecimal prodcut = new BigDecimal(factors[0]);
            for (int i = 1; i < factors.length; ++i) {
                prodcut = prodcut.multiply(new BigDecimal(factors[i]));
            }
            return prodcut.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String divide(String dividend, String divisor) {
        try {
            BigDecimal bdDividend = new BigDecimal(dividend);
            BigDecimal bdDivisor = new BigDecimal(divisor);
            try {
                return bdDividend.divide(bdDivisor).toString();
            }
            catch (ArithmeticException ae) {
                int scale = Math.max(bdDividend.scale(), bdDivisor.scale()) + 1;
                return Functions.divide(dividend, divisor, scale);
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String divide(String dividend, String divisor, int scale) {
        try {
            BigDecimal bdDividend = new BigDecimal(dividend);
            BigDecimal bdDivisor = new BigDecimal(divisor);
            return bdDividend.divide(bdDivisor, scale, RoundingMode.HALF_UP).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String average(String ... values) {
        if (values != null) {
            return Functions.divide(Functions.sum(values), values.length + "");
        }
        return null;
    }

    public static String average(int scale, String ... values) {
        if (values != null) {
            return Functions.divide(Functions.sum(values), values.length + "", scale);
        }
        return null;
    }

    public static String exp(String exponent) {
        try {
            BigDecimal bd = new BigDecimal(exponent);
            return Math.exp(bd.doubleValue()) + "";
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String log(String val) {
        try {
            BigDecimal bd = new BigDecimal(val);
            return Math.log(bd.doubleValue()) + "";
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String min(String ... values) {
        try {
            int start = 0;
            while (values[start] == null) {
                ++start;
            }
            BigDecimal bd = new BigDecimal(values[start]);
            for (int i = start + 1; i < values.length; ++i) {
                BigDecimal bd2;
                if (values[i] == null || bd.compareTo(bd2 = new BigDecimal(values[i])) <= 0) continue;
                bd = bd2;
            }
            return bd.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String max(String ... values) {
        try {
            int start = 0;
            while (values[start] == null) {
                ++start;
            }
            BigDecimal bd = new BigDecimal(values[start]);
            for (int i = start + 1; i < values.length; ++i) {
                BigDecimal bd2;
                if (values[i] == null || bd.compareTo(bd2 = new BigDecimal(values[i])) >= 0) continue;
                bd = bd2;
            }
            return bd.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String pow(String base, String exponent) {
        try {
            BigDecimal bdBase = new BigDecimal(base);
            BigDecimal bdExp = new BigDecimal(exponent);
            return Math.pow(bdBase.doubleValue(), bdExp.doubleValue()) + "";
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String sqrt(String value) {
        try {
            BigDecimal bd = new BigDecimal(value);
            return Math.sqrt(bd.doubleValue()) + "";
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String cos(String value) {
        try {
            BigDecimal bd = new BigDecimal(value);
            return Math.cos(bd.doubleValue()) + "";
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String sin(String value) {
        try {
            BigDecimal bd = new BigDecimal(value);
            return Math.sin(bd.doubleValue()) + "";
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String tan(String value) {
        try {
            BigDecimal bd = new BigDecimal(value);
            return Math.tan(bd.doubleValue()) + "";
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String acos(String value) {
        try {
            BigDecimal bd = new BigDecimal(value);
            return Math.acos(bd.doubleValue()) + "";
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String asin(String value) {
        try {
            BigDecimal bd = new BigDecimal(value);
            return Math.asin(bd.doubleValue()) + "";
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String atan(String value) {
        try {
            BigDecimal bd = new BigDecimal(value);
            return Math.atan(bd.doubleValue()) + "";
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String round(String value, int scale) {
        try {
            BigDecimal bd = new BigDecimal(value);
            bd = bd.setScale(scale, RoundingMode.HALF_UP);
            return bd.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean compare(String v1, String v2, CompareMode mode) {
        try {
            BigDecimal bd1 = new BigDecimal(v1);
            BigDecimal bd2 = new BigDecimal(v2);
            int ret = bd1.compareTo(bd2);
            switch (mode) {
                case LESS: {
                    return ret < 0;
                }
                case NOTLESS: {
                    return ret >= 0;
                }
                case GREATER: {
                    return ret > 0;
                }
                case NOTGREATER: {
                    return ret <= 0;
                }
                case EQUAL: {
                    return ret == 0;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static String[] removeNull(String[] in) {
        if (in == null) {
            return new String[0];
        }
        ArrayList<String> arr = new ArrayList<String>();
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            arr.add(in[i]);
        }
        if (in.length == arr.size()) {
            return in;
        }
        return arr.toArray(new String[0]);
    }

    public static boolean clearDirectory(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (dir.isDirectory()) {
            File[] subDirs;
            for (File subDir : subDirs = dir.listFiles()) {
                if (Functions.clearDirectory(subDir)) continue;
                return false;
            }
        }
        if (!dir.delete()) {
            log.error("{} is failed to be removed.", (Object)dir.getPath());
            return false;
        }
        return true;
    }

    public static String checkPctVal(String pctVal) {
        if (pctVal == null) {
            return null;
        }
        if (pctVal.contains("%")) {
            if (!pctVal.equals("%") && !pctVal.equals(".%") && pctVal.matches("\\d*\\.?\\d*%")) {
                pctVal = pctVal.substring(0, pctVal.length() - 1);
            } else {
                log.error("Invalid format for a percent value, [{}]", (Object)pctVal);
                return null;
            }
        }
        if (Functions.compare(pctVal, "100", CompareMode.GREATER) || Functions.compare(pctVal, "-100", CompareMode.LESS)) {
            log.error("Out of range for a percent value, [{}]", (Object)pctVal);
            return null;
        }
        return pctVal;
    }

    public static String revisePath(String path) {
        if (!path.trim().equals("")) {
            File f;
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if ((f = new File(path)) != null && !f.exists()) {
                f.mkdirs();
            }
            if (!f.isDirectory()) {
                f = f.getParentFile();
                path = f.getPath();
            }
        }
        return path;
    }

    public static enum CompareMode {
        LESS,
        NOTLESS,
        GREATER,
        NOTGREATER,
        EQUAL;

    }
}

