/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.agmip.ace.AcePathfinder;
import org.agmip.ace.util.AcePathfinderUtil;
import org.agmip.common.Event;
import org.agmip.common.Functions;
import org.agmip.functions.SoilHelper;
import org.agmip.functions.WeatherHelper;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentHelper.class);

    public static HashMap<String, ArrayList<String>> getAutoPlantingDate(HashMap data, String eDate, String lDate, String rain, String days) {
        int i;
        int expDur;
        double accRainAmtTotal;
        int intDays;
        int duration;
        Calendar eDateCal = Calendar.getInstance();
        Calendar lDateCal = Calendar.getInstance();
        int startYear = 0;
        ArrayList<String> pdates = new ArrayList<String>();
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        if (!ExperimentHelper.isValidDate(eDate, eDateCal, "-")) {
            LOG.error("INVALID EARLIST DATE:[" + eDate + "]");
            return new HashMap<String, ArrayList<String>>();
        }
        if (!ExperimentHelper.isValidDate(lDate, lDateCal, "-")) {
            LOG.error("INVALID LATEST DATE:[" + lDate + "]");
            return new HashMap<String, ArrayList<String>>();
        }
        if (eDateCal.after(lDateCal)) {
            lDateCal.set(1, lDateCal.get(1) + 1);
        }
        try {
            duration = Integer.parseInt(Functions.convertMsToDay(lDateCal.getTimeInMillis() - eDateCal.getTimeInMillis()));
        }
        catch (Exception e) {
            duration = 0;
        }
        try {
            intDays = Integer.parseInt(days);
        }
        catch (Exception e) {
            LOG.error("INVALID NUMBER FOR NUMBER OF DAYS OF ACCUMULATION");
            return new HashMap<String, ArrayList<String>>();
        }
        if (intDays <= 0) {
            LOG.error("NON-POSITIVE NUMBER FOR NUMBER OF DAYS OF ACCUMULATION");
            return new HashMap<String, ArrayList<String>>();
        }
        try {
            accRainAmtTotal = Double.parseDouble(rain);
        }
        catch (Exception e) {
            LOG.error("INVALID NUMBER FOR THRESHOLD RAINFALL AMOUNT");
            return new HashMap<String, ArrayList<String>>();
        }
        if (accRainAmtTotal <= 0.0) {
            LOG.error("NON-POSITIVE NUMBER FOR THRESHOLD RAINFALL AMOUNT");
            return new HashMap<String, ArrayList<String>>();
        }
        ArrayList dailyData = WeatherHelper.getDailyData(data);
        if (dailyData.isEmpty()) {
            LOG.error("EMPTY DAILY WEATHER DATA.");
            return new HashMap<String, ArrayList<String>>();
        }
        Map mgnData = (Map)MapUtil.getObjectOr((Map)data, (Object)"management", new HashMap());
        ArrayList eventData = (ArrayList)MapUtil.getObjectOr((Map)mgnData, (Object)"events", new ArrayList());
        try {
            expDur = Integer.parseInt(MapUtil.getValueOr((Map)data, (String)"exp_dur", (String)"1"));
        }
        catch (Exception e) {
            expDur = 1;
        }
        LOG.debug("EXP_DUR FOUND: {}", (Object)expDur);
        if (expDur > 1) {
            try {
                startYear = Integer.parseInt(MapUtil.getValueOr((Map)data, (String)"sc_year", (String)"").substring(0, 4));
            }
            catch (Exception e) {
                LOG.warn("Invalid SC_YEAR: {}", data.get("sc_year"));
                startYear = -99;
            }
        }
        LOG.debug("START YEAR: {}", (Object)startYear);
        Window[] windows = new Window[expDur];
        if (eventData.isEmpty()) {
            LOG.warn("EMPTY EVENT DATA.");
        } else {
            Event event = new Event(eventData, "planting");
            if (expDur == 1) {
                if (event.isEventExist()) {
                    HashMap plEvent = event.getCurrentEvent();
                    try {
                        startYear = Integer.parseInt(MapUtil.getValueOr((Map)plEvent, (String)"date", (String)"").substring(0, 4));
                    }
                    catch (Exception e) {
                        LOG.warn("Invalid planting date: {}", plEvent.get("date"));
                        startYear = -99;
                    }
                } else {
                    startYear = -99;
                }
            }
        }
        int startYearIndex = ExperimentHelper.getStartYearIndex(dailyData, startYear);
        if (startYearIndex == dailyData.size()) {
            if (expDur == 1) {
                startYearIndex = 0;
            } else {
                LOG.error("THE START YEAR IS OUT OF DATA RANGE (SC_YEAR:[" + startYear + "]) {}", (Object)startYearIndex);
                return new HashMap<String, ArrayList<String>>();
            }
        }
        int start = ExperimentHelper.getDailyRecIndex(dailyData, eDate, startYearIndex, 0);
        for (i = 0; i < windows.length; ++i) {
            int end = ExperimentHelper.getDailyRecIndex(dailyData, lDate, start, duration);
            windows[i] = new Window(start, end);
            if (i + 1 >= windows.length) continue;
            start = ExperimentHelper.getDailyRecIndex(dailyData, eDate, end, 365 - duration);
        }
        if (windows[0].start == dailyData.size()) {
            LOG.warn("NO VALID DAILY DATA FOR SEARCH WINDOW");
        }
        for (i = 0; i < windows.length; ++i) {
            int last = Math.min(windows[i].start + intDays, windows[i].end);
            double accRainAmt = 0.0;
            for (int j = windows[i].start; j < last; ++j) {
                try {
                    accRainAmt += Double.parseDouble(MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"rain", (String)"0"));
                }
                catch (Exception e) {
                    continue;
                }
                if (!(accRainAmt >= accRainAmtTotal)) continue;
                LOG.debug("1: " + MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"w_date", (String)"") + " : " + accRainAmt + ", " + (accRainAmt >= accRainAmtTotal));
                pdates.add(MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"w_date", (String)""));
                break;
            }
            if (accRainAmt >= accRainAmtTotal) continue;
            int outIndex = last;
            for (int j = last; j <= windows[i].end; ++j) {
                try {
                    accRainAmt -= Double.parseDouble(MapUtil.getValueOr((Map)((Map)dailyData.get(j - intDays)), (String)"rain", (String)"0"));
                    accRainAmt += Double.parseDouble(MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"rain", (String)"0"));
                }
                catch (Exception e) {
                    continue;
                }
                if (accRainAmt >= accRainAmtTotal) {
                    LOG.debug("2:" + MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"w_date", (String)"") + " : " + accRainAmt + ", " + (accRainAmt >= accRainAmtTotal));
                    pdates.add(MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"w_date", (String)""));
                    break;
                }
                ++outIndex;
            }
            if (!(accRainAmt < accRainAmtTotal)) continue;
            String lastDay = startYear > 0 ? startYear + i + lDate : (windows[i].end >= dailyData.size() ? MapUtil.getValueOr((Map)((Map)dailyData.get(dailyData.size() - 1)), (String)"w_date", (String)"") : MapUtil.getValueOr((Map)((Map)dailyData.get(windows[i].end)), (String)"w_date", (String)""));
            LOG.warn("Could not find an appropriate day to plant, using {}", (Object)lastDay);
            pdates.add(lastDay);
        }
        results.put("pdate", pdates);
        return results;
    }

    public static HashMap<String, ArrayList<String>> getAutoFillPlantingDate(HashMap data, String eDate, String lDate, String rain, String days) {
        double accRainAmtTotal;
        int intDays;
        Calendar eDateCal = Calendar.getInstance();
        Calendar lDateCal = Calendar.getInstance();
        ArrayList<Window> windows = new ArrayList<Window>();
        ArrayList<String> pdates = new ArrayList<String>();
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        if (!ExperimentHelper.isValidDate(eDate, eDateCal, "-")) {
            LOG.error("INVALID EARLIST DATE:[" + eDate + "]");
            return new HashMap<String, ArrayList<String>>();
        }
        if (!ExperimentHelper.isValidDate(lDate, lDateCal, "-")) {
            LOG.error("INVALID LATEST DATE:[" + lDate + "]");
            return new HashMap<String, ArrayList<String>>();
        }
        if (eDateCal.after(lDateCal)) {
            lDateCal.set(1, lDateCal.get(1) + 1);
        }
        int duration = (int)Math.round((double)(lDateCal.getTimeInMillis() - eDateCal.getTimeInMillis()) / 8.64E7);
        try {
            intDays = Integer.parseInt(days);
        }
        catch (Exception e) {
            LOG.error("INVALID NUMBER FOR NUMBER OF DAYS OF ACCUMULATION");
            return new HashMap<String, ArrayList<String>>();
        }
        if (intDays <= 0) {
            LOG.error("NON-POSITIVE NUMBER FOR NUMBER OF DAYS OF ACCUMULATION");
            return new HashMap<String, ArrayList<String>>();
        }
        try {
            accRainAmtTotal = Double.parseDouble(rain);
        }
        catch (Exception e) {
            LOG.error("INVALID NUMBER FOR THRESHOLD RAINFALL AMOUNT");
            return new HashMap<String, ArrayList<String>>();
        }
        if (accRainAmtTotal <= 0.0) {
            LOG.error("NON-POSITIVE NUMBER FOR THRESHOLD RAINFALL AMOUNT");
            return new HashMap<String, ArrayList<String>>();
        }
        ArrayList dailyData = WeatherHelper.getDailyData(data);
        if (dailyData.isEmpty()) {
            LOG.error("EMPTY DAILY WEATHER DATA.");
            return new HashMap<String, ArrayList<String>>();
        }
        Map mgnData = (Map)MapUtil.getObjectOr((Map)data, (Object)"management", new HashMap());
        ArrayList eventData = (ArrayList)MapUtil.getObjectOr((Map)mgnData, (Object)"events", new ArrayList());
        if (eventData.isEmpty()) {
            LOG.error("EMPTY EVENT DATA");
            return new HashMap<String, ArrayList<String>>();
        }
        Event event = new Event(eventData, "planting");
        if (event.isEventExist()) {
            int startYear;
            try {
                startYear = Integer.parseInt(MapUtil.getValueOr((Map)data, (String)"sc_year", (String)"").substring(0, 4));
            }
            catch (Exception e) {
                startYear = -99;
            }
            int startYearIndex = ExperimentHelper.getStartYearIndex(dailyData, startYear);
            int start = ExperimentHelper.getDailyRecIndex(dailyData, eDate, startYearIndex, 0);
            int end = ExperimentHelper.getDailyRecIndex(dailyData, lDate, start, duration);
            HashMap plEvent = event.getCurrentEvent();
            String pdate = MapUtil.getValueOr((Map)plEvent, (String)"date", (String)"");
            if (!pdate.equals("")) {
                LOG.debug("Find oringal PDATE {}, NO calculation required, AUTO_PDATE() exist", (Object)pdate);
                return new HashMap<String, ArrayList<String>>();
            }
            windows.add(new Window(start, end));
        }
        if (((Window)windows.get((int)0)).start == dailyData.size()) {
            LOG.warn("NO VALID DAILY DATA FOR SEARCH WINDOW");
        }
        for (int i = 0; i < windows.size(); ++i) {
            int last = Math.min(((Window)windows.get((int)i)).start + intDays, ((Window)windows.get((int)i)).end);
            double accRainAmt = 0.0;
            for (int j = ((Window)windows.get((int)i)).start; j < last; ++j) {
                try {
                    accRainAmt += Double.parseDouble(MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"rain", (String)"0"));
                }
                catch (Exception e) {
                    continue;
                }
                if (!(accRainAmt >= accRainAmtTotal)) continue;
                LOG.debug("1: " + MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"w_date", (String)"") + " : " + accRainAmt + ", " + (accRainAmt >= accRainAmtTotal));
                pdates.add(MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"w_date", (String)""));
                break;
            }
            if (accRainAmt >= accRainAmtTotal) continue;
            int outIndex = last;
            for (int j = last; j <= ((Window)windows.get((int)i)).end; ++j) {
                try {
                    accRainAmt -= Double.parseDouble(MapUtil.getValueOr((Map)((Map)dailyData.get(j - intDays)), (String)"rain", (String)"0"));
                    accRainAmt += Double.parseDouble(MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"rain", (String)"0"));
                }
                catch (Exception e) {
                    continue;
                }
                if (accRainAmt >= accRainAmtTotal) {
                    LOG.debug("2:" + MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"w_date", (String)"") + " : " + accRainAmt + ", " + (accRainAmt >= accRainAmtTotal));
                    pdates.add(MapUtil.getValueOr((Map)((Map)dailyData.get(j)), (String)"w_date", (String)""));
                    break;
                }
                ++outIndex;
            }
            if (!(accRainAmt < accRainAmtTotal)) continue;
            String lastDay = ((Window)windows.get((int)i)).end >= dailyData.size() ? MapUtil.getValueOr((Map)((Map)dailyData.get(dailyData.size() - 1)), (String)"w_date", (String)"") : MapUtil.getValueOr((Map)((Map)dailyData.get(((Window)windows.get((int)i)).end)), (String)"w_date", (String)"");
            LOG.error("Could not find an appropriate day to plant, using {}", (Object)lastDay);
            pdates.add(lastDay);
        }
        results.put("pdate", pdates);
        return results;
    }

    private static boolean isValidDate(String date, Calendar out, String separator) {
        try {
            String[] dates = date.split(separator);
            out.set(5, Integer.parseInt(dates[dates.length - 1]));
            out.set(2, Integer.parseInt(dates[dates.length - 2]));
            if (dates.length > 2) {
                out.set(1, Integer.parseInt(dates[dates.length - 3]));
            }
        }
        catch (Exception e) {
            try {
                out.set(5, Integer.parseInt(date.substring(date.length() - 2, date.length())));
                out.set(2, Integer.parseInt(date.substring(date.length() - 4, date.length() - 2)) - 1);
                if (date.length() > 4) {
                    out.set(1, Integer.parseInt(date.substring(date.length() - 8, date.length() - 4)) - 1);
                }
            }
            catch (Exception e2) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSameDate(String date1, String date2, String separator) {
        if ((date2 = date2.replace(separator, "")).equals("0229")) {
            try {
                int year1 = Integer.parseInt(date1.substring(2, 4));
                if (year1 % 4 != 0) {
                    return date1.endsWith("0228");
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return date1.endsWith(date2);
    }

    private static int getDailyRecIndex(ArrayList<Map> dailyData, String findDate, int start, int expectedDiff) {
        String date;
        if (start + expectedDiff < dailyData.size()) {
            date = MapUtil.getValueOr((Map)dailyData.get(start + expectedDiff), (String)"w_date", (String)"");
            if (ExperimentHelper.isSameDate(date, findDate, "-")) {
                return start + expectedDiff;
            }
            if (ExperimentHelper.isSameDate(date = MapUtil.getValueOr((Map)dailyData.get(start + ++expectedDiff), (String)"w_date", (String)""), findDate, "-")) {
                return start + expectedDiff;
            }
        }
        for (int j = start; j < dailyData.size(); ++j) {
            date = MapUtil.getValueOr((Map)dailyData.get(j), (String)"w_date", (String)"");
            if (!ExperimentHelper.isSameDate(date, findDate, "-")) continue;
            return j;
        }
        return dailyData.size();
    }

    private static int getStartYearIndex(ArrayList<Map> dailyData, int startYear) {
        int startYearIndex;
        if (startYear == -99) {
            LOG.warn("SC_YEAR is not valid in the data set, will using first year of weather data as start year");
            startYearIndex = 0;
        } else {
            startYearIndex = dailyData.size();
            for (int i = 0; i < dailyData.size(); ++i) {
                String w_date = MapUtil.getValueOr((Map)dailyData.get(i), (String)"w_date", (String)"");
                if (w_date.equals(startYear + "0101")) {
                    startYearIndex = i;
                    break;
                }
                if (!w_date.endsWith("0101")) continue;
                i += 364;
            }
        }
        return startYearIndex;
    }

    public static ArrayList<HashMap<String, String>> getFertDistribution(HashMap data, String num, String fecd, String feacd, String fedep, String[] offsets, String[] ptps) {
        String fen_tot;
        int iNum;
        ArrayList results = new ArrayList();
        try {
            iNum = Integer.parseInt(num);
            if (iNum < 1) {
                LOG.error("INPUT NUMBER OF FERTILIZER APPLICATIONS MUST BE A POSIIVE NUMBER");
                return results;
            }
        }
        catch (Exception e) {
            LOG.error("INPUT NUMBER OF FERTILIZER APPLICATIONS IS NOT A NUMBERIC STRING [" + num + "]");
            return results;
        }
        if (iNum != offsets.length || iNum != ptps.length) {
            if (iNum > offsets.length || !Functions.compare("100", Functions.round(Functions.sum(Arrays.copyOfRange(ptps, 0, iNum)), 0), Functions.CompareMode.EQUAL)) {
                LOG.error("THE REQUESTED NUMBER OF APPLICATION IS NOT MATCH WITH THE GIVEN OFFSET DATA");
                return results;
            }
        } else if (!Functions.compare("100", Functions.round(Functions.sum(ptps), 0), Functions.CompareMode.EQUAL)) {
            LOG.error("THE SUM OF PROPORTION OF TOTAL N ADDED (%) IS NOT EQUAL TO 100%");
            return results;
        }
        Map mgnData = (Map)MapUtil.getObjectOr((Map)data, (Object)"management", new HashMap());
        ArrayList eventData = (ArrayList)MapUtil.getObjectOr((Map)mgnData, (Object)"events", new ArrayList());
        try {
            fen_tot = MapUtil.getValueOr((Map)data, (String)"fen_tot", (String)"");
        }
        catch (Exception e) {
            LOG.error("FEN_TOT IS INVALID");
            return results;
        }
        ArrayList<String> output = new ArrayList<String>();
        for (Map events : eventData) {
            int i;
            String[] fdates;
            if (!MapUtil.getValueOr((Map)events, (String)"event", (String)"").equals("planting")) continue;
            String pdate = MapUtil.getValueOr((Map)events, (String)"date", (String)"");
            try {
                fdates = new String[iNum];
                for (i = 0; i < iNum; ++i) {
                    fdates[i] = Functions.dateOffset(pdate, offsets[i]);
                    if (fdates[i] != null) continue;
                    LOG.error("INVALID OFFSET NUMBER OF DAYS [" + offsets[i] + "]");
                    return results;
                }
            }
            catch (Exception e) {
                LOG.error("PAIR DATA IS IN VALID [" + e.getMessage() + "]");
                return results;
            }
            for (i = 0; i < iNum; ++i) {
                String feamn = Functions.round(Functions.product(fen_tot, ptps[i], "0.01"), 0);
                if (feamn == null) {
                    LOG.error("Invalid value for FEN_TOT {} or PTP {}", (Object)fen_tot, (Object)ptps[i]);
                }
                output.add(String.format("%s|%s", fdates[i], feamn));
            }
        }
        HashMap result = new HashMap();
        for (String addNew : output) {
            String[] tmp = addNew.split("[|]");
            AcePathfinderUtil.insertValue(result, (String)"fedate", (String)tmp[0]);
            AcePathfinderUtil.insertValue(result, (String)"fecd", (String)fecd);
            AcePathfinderUtil.insertValue(result, (String)"feacd", (String)feacd);
            AcePathfinderUtil.insertValue(result, (String)"fedep", (String)fedep);
            if (tmp[1].equals("null")) continue;
            AcePathfinderUtil.insertValue(result, (String)"feamn", (String)tmp[1]);
        }
        results = MapUtil.getBucket(result, (String)"management").getDataList();
        return results;
    }

    public static ArrayList<HashMap<String, String>> getOMDistribution(HashMap expData, String offset, String omcd, String omc2n, String omdep, String ominp, String dmr) {
        ArrayList eventData = new ArrayList();
        ArrayList originalEvents = MapUtil.getBucket((Map)expData, (String)"management").getDataList();
        String omamt = MapUtil.getValueOr((Map)expData, (String)"om_tot", (String)"");
        if (omamt == null || omamt.equals("")) {
            LOG.debug("OM_TOT IS NOT AVAILABLE, USING OMAMT");
            Event omEvent = new Event(originalEvents, "organic_matter");
            omamt = (String)omEvent.getCurrentEvent().get("omamt");
        }
        if (omamt == null || omamt.equals("")) {
            LOG.error("NEITHER OM_TOT NOR OMAMT ARE AVAILABLE");
            return eventData;
        }
        Event events = new Event(originalEvents, "planting");
        String pdate = (String)events.getCurrentEvent().get("date");
        if (pdate == null || pdate.equals("")) {
            LOG.error("PLANTING DATE IS NOT AVAILABLE");
            return eventData;
        }
        String odate = Functions.dateOffset(pdate, offset);
        if (odate == null) {
            LOG.error("INVALID OFFSET NUMBER OF DAYS [" + offset + "]");
            return eventData;
        }
        String omnpct = Functions.divide(Functions.divide("100.0", dmr, 3), omc2n, 2);
        if (omnpct == null) {
            LOG.error("INVALID VALUES FOR DMR and OMC2N");
            return eventData;
        }
        HashMap result = new HashMap();
        AcePathfinderUtil.insertValue(result, (String)"omdat", (String)odate);
        AcePathfinderUtil.insertValue(result, (String)"omcd", (String)omcd);
        AcePathfinderUtil.insertValue(result, (String)"omamt", (String)omamt);
        AcePathfinderUtil.insertValue(result, (String)"omc2n", (String)omc2n);
        AcePathfinderUtil.insertValue(result, (String)"omdep", (String)omdep);
        AcePathfinderUtil.insertValue(result, (String)"ominp", (String)ominp);
        AcePathfinderUtil.insertValue(result, (String)"omn%", (String)omnpct);
        eventData = MapUtil.getBucket(result, (String)"management").getDataList();
        return eventData;
    }

    public static HashMap<String, ArrayList<String>> getStableCDistribution(HashMap data, String som3_0, String pp, String rd) {
        String[] slocs;
        String[] sllbs;
        String som2_0;
        String k;
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        ArrayList<String> slscArr = new ArrayList<String>();
        int finalScale = 2;
        LOG.debug("Checkpoint 1");
        try {
            k = Functions.divide(Functions.log("0.02") + "", Functions.substract(rd, pp), finalScale + 1);
            som2_0 = Functions.multiply("0.95", Functions.substract("1", som3_0));
        }
        catch (Exception e) {
            LOG.error("INVALID INPUT FOR NUMBERIC VALUE");
            return results;
        }
        ArrayList soilLayers = SoilHelper.getSoilLayer(data);
        if (soilLayers == null) {
            return results;
        }
        if (soilLayers.isEmpty()) {
            LOG.error("SOIL LAYER DATA IS EMPTY");
            return results;
        }
        try {
            sllbs = new String[soilLayers.size()];
            slocs = new String[soilLayers.size()];
            for (int i = 0; i < soilLayers.size(); ++i) {
                sllbs[i] = (String)MapUtil.getObjectOr((Map)((Map)soilLayers.get(i)), (Object)"sllb", (Object)"");
                slocs[i] = (String)MapUtil.getObjectOr((Map)((Map)soilLayers.get(i)), (Object)"sloc", (Object)"");
            }
        }
        catch (NumberFormatException e) {
            LOG.error("INVALID NUMBER FOR SLOC OR SLLB IN DATA [" + e.getMessage() + "]");
            return results;
        }
        LOG.debug("Checkpoint 2");
        LOG.debug("Checkpoint 3");
        String last = "0";
        for (int i = 0; i < soilLayers.size(); ++i) {
            String mid = Functions.average(sllbs[i], last);
            last = sllbs[i];
            String f = SoilHelper.getGrowthFactor(mid, pp, k, som2_0);
            String som3_fac = Functions.substract("1", Functions.divide(Functions.max("0.02", f), "0.95", finalScale + 1));
            slscArr.add(Functions.round(Functions.multiply(slocs[i], som3_fac), finalScale));
        }
        results.put("slsc", slscArr);
        return results;
    }

    public static ArrayList<ArrayList<HashMap<String, String>>> getAutoEventDate(Map data) {
        int expDur;
        ArrayList<ArrayList<HashMap<String, String>>> results = new ArrayList<ArrayList<HashMap<String, String>>>();
        try {
            expDur = Integer.parseInt(MapUtil.getValueOr((Map)data, (String)"exp_dur", (String)"1"));
        }
        catch (Exception e) {
            expDur = 1;
        }
        if (expDur <= 1) {
            LOG.warn("Experiment duration is not more than 1, AUTO_REPLICATE_EVENTS won't be applied.");
            return results;
        }
        ArrayList events = MapUtil.getBucket((Map)data, (String)"management").getDataList();
        while (results.size() < expDur) {
            results.add(new ArrayList());
        }
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < events.size(); ++i) {
            HashMap event = (HashMap)events.get(i);
            String date = MapUtil.getValueOr((Map)event, (String)"date", (String)"");
            if (date.equals("")) {
                String eventType = MapUtil.getValueOr((Map)event, (String)"event", (String)"unknown");
                LOG.warn("Original {} event has an invalid date: [{}].", (Object)eventType, (Object)date);
            }
            String edate = MapUtil.getValueOr((Map)event, (String)"edate", (String)"");
            for (int j = 0; j < expDur; ++j) {
                HashMap<String, String> newEvent = new HashMap<String, String>();
                newEvent.putAll(event);
                if (!date.equals("")) {
                    newEvent.put("date", Functions.yearOffset(date, j + ""));
                }
                if (!edate.equals("")) {
                    newEvent.put("edate", Functions.yearOffset(edate, j + ""));
                }
                results.get(j).add(newEvent);
            }
        }
        return results;
    }

    public static ArrayList<ArrayList<HashMap<String, String>>> getAutoEvent(Map data) {
        String sc_year = MapUtil.getValueOr((Map)data, (String)"sc_year", (String)"");
        if (sc_year.equals("")) {
            LOG.debug("SC_YEAR is unavailable in the data set, will use original planting date as start year");
            return ExperimentHelper.getAutoEventDate(data);
        }
        try {
            int expDur;
            try {
                expDur = Integer.parseInt(MapUtil.getValueOr((Map)data, (String)"exp_dur", (String)"1"));
            }
            catch (Exception e) {
                expDur = 1;
            }
            if (expDur <= 1) {
                LOG.warn("Experiment duration is not more than 1, AUTO_REPLICATE_EVENTS won't be applied.");
                return new ArrayList<ArrayList<HashMap<String, String>>>();
            }
            String pdate = ExperimentHelper.getFstPdate(data, "");
            if (pdate.equals("")) {
                LOG.warn("PDATE is unavailable in the data set, will use original event date as start year");
                return ExperimentHelper.getAutoEventDate(data);
            }
            String[] pdates = new String[expDur];
            String newPdate = Functions.yearOffset(pdate, Functions.substract(sc_year, pdate.substring(0, 4)));
            for (int i = 0; i < pdates.length; ++i) {
                pdates[i] = Functions.yearOffset(newPdate, i + "");
            }
            return ExperimentHelper.getAutoEventDate(data, pdates);
        }
        catch (Exception e) {
            LOG.warn("SC_YEAR contain invalid value, will use original planting date as start year");
            return ExperimentHelper.getAutoEventDate(data);
        }
    }

    public static ArrayList<ArrayList<HashMap<String, String>>> getAutoEventDate(Map data, String[] pdates) {
        ArrayList<ArrayList<HashMap<String, String>>> results = new ArrayList<ArrayList<HashMap<String, String>>>();
        if (pdates.length < 1) {
            LOG.error("There is no PDATE can be used for event generation.");
            return results;
        }
        ArrayList events = MapUtil.getBucket((Map)data, (String)"management").getDataList();
        while (results.size() < pdates.length) {
            results.add(new ArrayList());
        }
        String orgPdate = MapUtil.getValueOr((Map)data, (String)"origin_pdate", (String)"-99");
        if (orgPdate.equals("")) {
            LOG.error("The original PDATE is missing, can't calculate other event date");
        } else if (orgPdate.equals("-99")) {
            orgPdate = ExperimentHelper.getFstPdate(data, "");
        }
        if (orgPdate.equals("")) {
            LOG.warn("The original PDATE is missing, use first given PDATE {} as original one", (Object)pdates[0]);
            orgPdate = pdates[0];
        } else {
            LOG.debug("Find original PDATE {}", (Object)orgPdate);
        }
        for (int i = 0; i < events.size(); ++i) {
            HashMap event = (HashMap)events.get(i);
            String date = MapUtil.getValueOr((Map)event, (String)"date", (String)"");
            String orgDap = "";
            String eventType = MapUtil.getValueOr((Map)event, (String)"event", (String)"unknown");
            if (eventType.equals("planting")) {
                orgDap = "0";
            } else if (date.equals("")) {
                LOG.debug("Original {} event has an invalid date: [{}].", (Object)eventType, (Object)date);
            } else {
                orgDap = Functions.calcDAP(date, orgPdate);
                LOG.debug("Original {} event date: [{}].", (Object)eventType, (Object)date);
                LOG.debug("Original {} event's DAP: [{}]", (Object)eventType, (Object)orgDap);
            }
            String edate = MapUtil.getValueOr((Map)event, (String)"edate", (String)"");
            String orgEDap = "";
            if (!edate.equals("")) {
                orgEDap = Functions.calcDAP(edate, orgPdate);
                LOG.debug("Original EDATE's DAP: [{}].", (Object)orgDap);
            }
            for (int j = 0; j < pdates.length; ++j) {
                HashMap<String, String> newEvent = new HashMap<String, String>();
                newEvent.putAll(event);
                if (!date.equals("")) {
                    newEvent.put("date", Functions.dateOffset(pdates[j], orgDap));
                }
                if (!edate.equals("")) {
                    newEvent.put("edate", Functions.dateOffset(pdates[j], orgEDap));
                }
                results.get(j).add(newEvent);
            }
        }
        return results;
    }

    public static ArrayList<HashMap<String, String>> getPaddyIrrigation(HashMap data, String bundNum, String percRate, String plowpanDept, String[] offsets, String[] maxVals, String[] minVals) {
        int iNum;
        ArrayList results = new ArrayList();
        try {
            iNum = Integer.parseInt(bundNum);
            if (iNum < 1) {
                LOG.error("INPUT NUMBER OF BUND HEIGHT MUST BE A POSITIVE NUMBER");
                return results;
            }
        }
        catch (Exception e) {
            LOG.error("INPUT NUMBER OF FERTILIZER APPLICATIONS IS NOT A NUMBERIC STRING [" + bundNum + "]");
            return results;
        }
        if (iNum != offsets.length || iNum != maxVals.length || iNum != minVals.length) {
            LOG.error("THE REQUESTED NUMBER OF APPLICATION IS NOT MATCH WITH THE GIVEN OFFSET DATA");
            return results;
        }
        Map mgnData = (Map)MapUtil.getObjectOr((Map)data, (Object)"management", new HashMap());
        ArrayList eventData = (ArrayList)MapUtil.getObjectOr((Map)mgnData, (Object)"events", new ArrayList());
        Event events = new Event(eventData, "planting");
        String pdate = (String)events.getCurrentEvent().get("date");
        if (pdate == null || pdate.equals("")) {
            LOG.error("PLANTING DATE IS NOT AVAILABLE");
            return eventData;
        }
        String[] idates = new String[iNum];
        try {
            for (int i = 0; i < iNum; ++i) {
                idates[i] = Functions.dateOffset(pdate, offsets[i]);
                if (idates[i] != null) continue;
                LOG.error("INVALID OFFSET NUMBER OF DAYS [" + offsets[i] + "]");
                return results;
            }
        }
        catch (Exception e) {
            LOG.error("PAIR DATA IS IN VALID [" + e.getMessage() + "]");
            return results;
        }
        HashMap result = new HashMap();
        AcePathfinderUtil.insertValue(result, (String)"idate", (String)idates[0]);
        AcePathfinderUtil.insertValue(result, (String)"irop", (String)"IR010");
        AcePathfinderUtil.insertValue(result, (String)"irval", (String)plowpanDept);
        AcePathfinderUtil.insertValue(result, (String)"idate", (String)idates[0]);
        AcePathfinderUtil.insertValue(result, (String)"irop", (String)"IR008");
        AcePathfinderUtil.insertValue(result, (String)"irval", (String)percRate);
        for (int i = 0; i < idates.length; ++i) {
            AcePathfinderUtil.insertValue(result, (String)"idate", (String)idates[i]);
            AcePathfinderUtil.insertValue(result, (String)"irop", (String)"IR009");
            AcePathfinderUtil.insertValue(result, (String)"irval", (String)maxVals[i]);
            AcePathfinderUtil.insertValue(result, (String)"idate", (String)idates[i]);
            AcePathfinderUtil.insertValue(result, (String)"irop", (String)"IR011");
            AcePathfinderUtil.insertValue(result, (String)"irval", (String)minVals[i]);
        }
        results = MapUtil.getBucket(result, (String)"management").getDataList();
        return results;
    }

    public static String getFstPdate(Map data, String defValue) {
        ArrayList events = MapUtil.getBucket((Map)data, (String)"management").getDataList();
        Event event = new Event(events, "planting");
        return MapUtil.getValueOr((Map)event.getCurrentEvent(), (String)"date", (String)defValue);
    }

    public static HashMap<String, String> createEvent(HashMap data, String typeStr, String dap, HashMap<String, String> info, boolean isStrictID) {
        String date;
        HashMap<String, String> newEvent = new HashMap<String, String>();
        try {
            EventType type = EventType.valueOf(typeStr.toUpperCase());
            typeStr = type.toString().toLowerCase();
        }
        catch (IllegalArgumentException e) {
            LOG.error("{} event is not recognized, please try other event name", (Object)typeStr);
            return new HashMap<String, String>();
        }
        catch (Exception e) {
            LOG.error(Functions.getStackTrace(e));
            return new HashMap<String, String>();
        }
        newEvent.put("event", typeStr);
        String pdate = ExperimentHelper.getFstPdate(data, "");
        if (!pdate.equals("")) {
            date = Functions.dateOffset(pdate, dap);
            if (date == null) {
                LOG.error("Given days after planting has a invalid value {}", (Object)dap);
                return new HashMap<String, String>();
            }
        } else {
            LOG.error("Planting date is not available in the given data set");
            return new HashMap<String, String>();
        }
        newEvent.put("date", date);
        if (isStrictID) {
            String[] ids;
            for (String id : ids = info.keySet().toArray(new String[0])) {
                String path = AcePathfinder.INSTANCE.getPath(id);
                if (path != null && path.contains(typeStr)) continue;
                LOG.warn("{} is not belong to {} event, please check if it is a typo");
            }
        }
        newEvent.putAll(info);
        return newEvent;
    }

    public static ArrayList<HashMap<String, String>> getAutoIrrigationEvent(HashMap data, String irrNum, String baseTemp, String[] gddArr, String[] irvalArr) {
        int i;
        String fstDay;
        long fstDayMis;
        int iIrrNum;
        ArrayList<HashMap<String, String>> irrEvts = new ArrayList<HashMap<String, String>>();
        ArrayList dailyArr = WeatherHelper.getDailyData(data);
        if (dailyArr.isEmpty()) {
            LOG.error("The weather data for {} is missing", (Object)MapUtil.getValueOr((Map)data, (String)"exname", (String)"unknown experiment"));
            return irrEvts;
        }
        try {
            iIrrNum = Functions.numericStringToBigInteger(irrNum).intValue();
        }
        catch (Exception e) {
            LOG.error("The number for irrigation event is invalid");
            return irrEvts;
        }
        if (gddArr.length != iIrrNum || irvalArr.length != iIrrNum) {
            LOG.error("There is not enough pairs of GDD and irrigation amount for {} irrigation", (Object)iIrrNum);
            return irrEvts;
        }
        for (String gdd : gddArr) {
            if (gdd != null && !gdd.equals("") && gdd.matches("-?\\d+(.\\d*)?")) continue;
            LOG.error("Invalid input GDD value {} has been deceted", (Object)gdd);
            return irrEvts;
        }
        for (String irval : irvalArr) {
            if (irval != null && !irval.equals("") && irval.matches("-?\\d+(.\\d*)?")) continue;
            LOG.error("Invalid input irrigation amount value {} has been deceted", (Object)irval);
            return irrEvts;
        }
        Event event = new Event(MapUtil.getBucket((Map)data, (String)"management").getDataList(), "planting");
        String pdate = MapUtil.getValueOr((Map)event.getCurrentEvent(), (String)"date", (String)"");
        if (pdate.equals("")) {
            LOG.error("Planting event is not valid in the data set for calculating irrigation date");
            return irrEvts;
        }
        long pdateMis = Functions.convertFromAgmipDateString(pdate).getTime();
        int startIdx = (int)Math.round((double)(pdateMis - (fstDayMis = Functions.convertFromAgmipDateString(fstDay = MapUtil.getValueOr((Map)((Map)dailyArr.get(0)), (String)"w_date", (String)"")).getTime())) / 8.64E7);
        if (startIdx >= dailyArr.size() || !pdate.equals(MapUtil.getValueOr((Map)((Map)dailyArr.get(startIdx)), (String)"w_date", (String)""))) {
            if (pdateMis > Functions.convertFromAgmipDateString(MapUtil.getValueOr((Map)((Map)dailyArr.get(dailyArr.size() - 1)), (String)"w_date", (String)"")).getTime()) {
                LOG.error("Not enough weather daily data for calculating irrigation date based plnating date of {}", (Object)pdate);
                return irrEvts;
            }
            boolean isExist = false;
            for (i = 0; i < dailyArr.size(); ++i) {
                if (!pdate.equals(MapUtil.getValueOr((Map)((Map)dailyArr.get(i)), (String)"pdate", (String)""))) continue;
                startIdx = i;
                isExist = true;
                break;
            }
            if (!isExist) {
                LOG.error("Could not find planting date ({}) in the weather daily date", (Object)pdate);
                return irrEvts;
            }
        }
        String calGdd = "0";
        int j = 0;
        for (i = startIdx; i < dailyArr.size(); ++i) {
            HashMap daily = (HashMap)dailyArr.get(i);
            String date = MapUtil.getValueOr((Map)daily, (String)"w_date", (String)"");
            String tavg = Functions.average(MapUtil.getValueOr((Map)daily, (String)"tmax", (String)""), MapUtil.getValueOr((Map)daily, (String)"tmin", (String)""));
            if (tavg == null) {
                LOG.warn("Invalid TMAX/TMIN detected on {}", (Object)date);
                continue;
            }
            String gdd = Functions.substract(tavg, baseTemp);
            if (gdd != null && Functions.compare(gdd, "0", Functions.CompareMode.GREATER)) {
                calGdd = Functions.sum(calGdd, gdd);
            }
            if (Functions.compare(calGdd, gddArr[j], Functions.CompareMode.NOTLESS)) {
                LOG.debug(date + " TAVG: {}\t IcrGDD: {}\t GDD: " + calGdd + "\t Target :" + gddArr[j] + " [Picked up]", (Object)tavg, (Object)Functions.substract(tavg, baseTemp));
                HashMap<String, String> irrEvt = new HashMap<String, String>();
                irrEvt.put("event", "irrigation");
                irrEvt.put("date", date);
                irrEvt.put("irval", irvalArr[j]);
                irrEvt.put("irop", "IR001");
                irrEvts.add(irrEvt);
                calGdd = "0";
                if (++j < gddArr.length) continue;
                break;
            }
            LOG.debug(date + " TAVG: {}\t IcrGDD: {}\t GDD: " + calGdd + "\t Target :" + gddArr[j], (Object)tavg, (Object)Functions.substract(tavg, baseTemp));
        }
        return irrEvts;
    }

    protected static ArrayList getICLayer(HashMap data) {
        if (data.containsKey("initial_conditions") || !data.containsKey("soilLayer")) {
            return MapUtil.getBucket((Map)data, (String)"initial_conditions").getDataList();
        }
        return new MapUtil.BucketEntry(data).getDataList();
    }

    public static enum EventType {
        PLANTING,
        IRRIGATION,
        AUTO_IRRIG,
        FERTILIZER,
        TILLAGE,
        ORGANIC_MATTER,
        HARVEST,
        CHEMICALS,
        MULCH;

    }

    private static class Window {
        public int start;
        public int end;

        public Window(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

