/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.translators.soil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.agmip.translators.soil.LayerReducer;
import org.agmip.translators.soil.SAReducerDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerReducerUtil {
    public static final Logger log = LoggerFactory.getLogger(LayerReducerUtil.class);
    private static String UNKNOWN_DEFAULT_VALUE = "0.0";

    public static ArrayList<HashMap<String, String>> computeSoilLayerSize(ArrayList<HashMap<String, String>> soilsData) {
        float deep = 0.0f;
        ArrayList<HashMap<String, String>> newSoilsData = new ArrayList<HashMap<String, String>>();
        for (HashMap<String, String> currentSoil : soilsData) {
            HashMap<String, String> newCurrentSoil = new HashMap<String, String>(currentSoil);
            newCurrentSoil.put(LayerReducer.SLLB, new Float(Float.parseFloat(currentSoil.get(LayerReducer.SLLB)) - deep).toString());
            deep = Float.parseFloat(currentSoil.get(LayerReducer.SLLB));
            newSoilsData.add(newCurrentSoil);
        }
        return newSoilsData;
    }

    public static String defaultValue(String key) {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put("slcly", "12.6");
        defaultValues.put("salb", "0.25");
        defaultValues.put("slphw", "6.2");
        defaultValues.put("sksat", "0.0");
        defaultValues.put("caco3", "0.0");
        defaultValues.put("sloc", "0.1");
        defaultValues.put("slll", "0.0");
        defaultValues.put("icnh4", "0.0");
        defaultValues.put("icno3", "0.0");
        defaultValues.put("ich2o", "0.0");
        String value = defaultValues.containsKey(key) ? (String)defaultValues.get(key) : UNKNOWN_DEFAULT_VALUE;
        return value;
    }

    public static void mergeSoilAndInitializationData(ArrayList<HashMap<String, String>> soilsData, ArrayList<HashMap<String, String>> initData) {
        int index = 0;
        log.debug("Init data size : " + initData.size());
        log.debug("Soil data size : " + soilsData.size());
        for (HashMap<String, String> soilData : soilsData) {
            if (index >= initData.size()) {
                log.error("Unable to merge soil information, initial condition information unavailable");
                break;
            }
            if (initData.get(index).get(SAReducerDecorator.ICBL).equals(soilData.get(LayerReducer.SLLB))) {
                soilData.putAll((Map<String, String>)initData.get(index));
            } else {
                log.error("Unable to merge soil information, inconsistent soil information");
            }
            ++index;
        }
    }
}

