/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;

public class PackageOutputManager
implements OutputManager {
    private final File outputDir;

    public PackageOutputManager(String baseDirectoryName, String packageName) throws IOException {
        Verify.notNull(baseDirectoryName, "baseDirectoryName");
        Verify.notNull(packageName, "packageName");
        String dirName = (baseDirectoryName.endsWith("" + File.separatorChar) ? baseDirectoryName : baseDirectoryName + File.separatorChar) + packageName.replace('.', File.separatorChar);
        this.outputDir = new File(dirName);
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + dirName);
        }
    }

    @Override
    public Writer createOutput(String name) throws IOException {
        File targetFile = new File(this.outputDir, name + ".java");
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8"));
    }
}

