/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.io;

import java.io.IOException;
import java.io.OutputStream;
import org.agrona.MutableDirectBuffer;

public class MutableDirectBufferOutputStream
extends OutputStream {
    private MutableDirectBuffer buffer;
    private int offset;
    private int length;
    private int position;

    public MutableDirectBufferOutputStream() {
    }

    public MutableDirectBufferOutputStream(MutableDirectBuffer buffer) {
        this.wrap(buffer, 0, buffer.capacity());
    }

    public MutableDirectBufferOutputStream(MutableDirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public void wrap(MutableDirectBuffer buffer) {
        this.wrap(buffer, 0, buffer.capacity());
    }

    public void wrap(MutableDirectBuffer buffer, int offset, int length) {
        if (null == buffer) {
            throw new NullPointerException("buffer cannot be null");
        }
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        this.position = 0;
    }

    public int position() {
        return this.position;
    }

    public int offset() {
        return this.offset;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int length() {
        return this.length;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.position == this.length) {
            throw new IllegalStateException("position has reached the end of underlying buffer");
        }
        this.buffer.putByte(this.offset + this.position, (byte)b);
        ++this.position;
    }

    @Override
    public void write(byte[] srcBytes, int srcOffset, int length) throws IOException {
        long resultingOffset = (long)this.position + (long)length;
        if (resultingOffset >= (long)this.length) {
            throw new IllegalStateException("insufficient capacity in the buffer");
        }
        this.buffer.putBytes(this.offset + this.position, srcBytes, srcOffset, length);
        this.position += length;
    }
}

