/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.broadcast;

import java.nio.ByteBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastReceiver;

public class CopyBroadcastReceiver {
    public static final int SCRATCH_BUFFER_LENGTH = 4096;
    private final BroadcastReceiver receiver;
    private final UnsafeBuffer scratchBuffer;

    public CopyBroadcastReceiver(BroadcastReceiver receiver, int scratchBufferLength) {
        this.receiver = receiver;
        this.scratchBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(scratchBufferLength));
        while (receiver.receiveNext()) {
        }
    }

    public CopyBroadcastReceiver(BroadcastReceiver receiver) {
        this(receiver, 4096);
    }

    public int receive(MessageHandler handler) {
        int messagesReceived = 0;
        BroadcastReceiver receiver = this.receiver;
        long lastSeenLappedCount = receiver.lappedCount();
        if (receiver.receiveNext()) {
            int capacity;
            if (lastSeenLappedCount != receiver.lappedCount()) {
                throw new IllegalStateException("Unable to keep up with broadcast buffer");
            }
            int length = receiver.length();
            if (length > (capacity = this.scratchBuffer.capacity())) {
                throw new IllegalStateException(String.format("Buffer required length of %d but only has %d", length, capacity));
            }
            int msgTypeId = receiver.typeId();
            this.scratchBuffer.putBytes(0, receiver.buffer(), receiver.offset(), length);
            if (!receiver.validate()) {
                throw new IllegalStateException("Unable to keep up with broadcast buffer");
            }
            handler.onMessage(msgTypeId, this.scratchBuffer, 0, length);
            messagesReceived = 1;
        }
        return messagesReceived;
    }
}

