/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.codegenerator.api.abi;

import java.util.List;
import org.aion4j.avm.codegenerator.api.abi.ABI;
import org.aion4j.avm.codegenerator.api.abi.ABIMethod;
import org.aion4j.codegenerator.abi.antlr4.ABIBaseListener;
import org.aion4j.codegenerator.abi.antlr4.ABIParser;

class ABIParserListenerImpl
extends ABIBaseListener {
    ABI abi = new ABI();

    @Override
    public void enterVersion(ABIParser.VersionContext ctx) {
        System.out.println("version: " + ctx.getText());
        this.abi.setVersion(ctx.getText());
    }

    @Override
    public void exitContract_name(ABIParser.Contract_nameContext ctx) {
        System.out.println("Contract class: " + ctx.getText());
        this.abi.setContractClass(ctx.getText());
    }

    @Override
    public void exitClinit(ABIParser.ClinitContext ctx) {
        System.out.println("clinit: " + ctx.getText());
        List<ABIParser.ParamTypeContext> paramTypeContextList = ctx.paramType();
        for (ABIParser.ParamTypeContext paramType : paramTypeContextList) {
            String paramTypeText = paramType.getText();
            this.abi.getClint().add(paramTypeText);
        }
    }

    @Override
    public void exitMethodDeclaration(ABIParser.MethodDeclarationContext ctx) {
        String methodName = ctx.methodName().getText();
        ABIMethod abiMethod = new ABIMethod();
        abiMethod.setSignature(ctx.getText());
        abiMethod.setMethodName(methodName);
        List<ABIParser.ParamTypeContext> paramTypeContextList = ctx.paramType();
        for (ABIParser.ParamTypeContext paramType : paramTypeContextList) {
            String paramTypeText = paramType.getText();
            abiMethod.getParameters().add(paramTypeText);
        }
        abiMethod.setReturnType(ctx.returnType().getText());
        this.abi.getMethods().add(abiMethod);
    }

    public ABI getABI() {
        return this.abi;
    }
}

