/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.codegenerator.generators.clientjs;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aion4j.avm.codegenerator.api.abi.ABI;
import org.aion4j.avm.codegenerator.api.abi.ABIMethod;
import org.aion4j.avm.codegenerator.api.exception.CodeGenerationException;
import org.aion4j.avm.codegenerator.api.generator.BaseGenerator;
import org.aion4j.avm.codegenerator.api.impl.VelocityTemplateGenerator;
import org.aion4j.avm.codegenerator.generators.clientjs.JsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VueJsClientGenerator
extends BaseGenerator {
    private final Logger logger = LoggerFactory.getLogger(VueJsClientGenerator.class);
    private final String CONTRACT_CALL_WITH_ABI_JS_TEMPLATE = "templates/client/js/contract-abi.js.vm";
    private final String CONTRACT_CALL_JS_TEMPLATE = "templates/client/js/contract.js.vm";
    private final String PACKAGE_JSON_TEMPLATE = "templates/client/js/vue/package.json.vm";
    private final String BABEL_CONFIG_JS_VM = "templates/client/js/vue/babel.config.js.vm";
    private final String GITIGNORE_VM = "templates/client/js/vue/.gitignore.vm";
    private final String MAIN_JS_VM = "templates/client/js/vue/src/main.js.vm";
    private final String APP_VUE_VM = "templates/client/js/vue/src/App.vue.vm";
    private final String COMPONENT_VM = "templates/client/js/vue/src/components/component.vue.vm";
    private final String INDEX_HTML_VM = "templates/client/js/vue/public/index.html.vm";

    public VueJsClientGenerator(boolean verbose) {
        this.templateGenerator = new VelocityTemplateGenerator();
        this.verbose = verbose;
    }

    @Override
    protected void doGenerate(String baseDir, String packageDir, HashMap<String, Object> data) {
        try {
            data.put("mode", "vue");
            JsHelper jsHelper = new JsHelper();
            ABI abi = (ABI)data.get("abi");
            List<ABIMethod> methods = abi.getMethods();
            data.put("_jshelper", jsHelper);
            this.createFolders(baseDir);
            File baseDirFile = new File(baseDir);
            File srcDir = new File(baseDir, "src");
            File componentsDir = new File(srcDir, "components");
            File publicDir = new File(baseDir, "public");
            this.createFile("templates/client/js/vue/package.json.vm", data, baseDirFile, "package.json");
            this.createFile("templates/client/js/vue/babel.config.js.vm", data, baseDirFile, "babel.config.js");
            this.createFile("templates/client/js/vue/src/main.js.vm", data, srcDir, "main.js");
            HashMap<String, Object> appVueData = new HashMap<String, Object>();
            appVueData.putAll(data);
            ArrayList<String> components = new ArrayList<String>();
            for (ABIMethod abiMethod : abi.getMethods()) {
                String componentJsName = jsHelper.methodNameToComponentName(abiMethod.getMethodName());
                components.add(componentJsName);
            }
            appVueData.put("components", components);
            this.createFile("templates/client/js/vue/src/App.vue.vm", appVueData, srcDir, "App.vue");
            this.createFile("templates/client/js/contract-abi.js.vm", data, srcDir, "contract-abi.js");
            for (ABIMethod method : methods) {
                String methodName = method.getMethodName();
                String componentName = jsHelper.methodNameToComponentName(methodName);
                HashMap<String, Object> tempData = new HashMap<String, Object>();
                tempData.putAll(data);
                tempData.put("method", method);
                tempData.put("component", componentName);
                this.createFile("templates/client/js/vue/src/components/component.vue.vm", tempData, componentsDir, componentName + ".vue");
            }
            this.createFile("templates/client/js/vue/public/index.html.vm", data, publicDir, "index.html");
        }
        catch (Exception e) {
            throw new CodeGenerationException("Error in generting vuejs client code", e);
        }
    }

    private void createFolders(String baseDir) {
        File src = new File(baseDir, "src");
        src.mkdirs();
        File components = new File(src, "components");
        components.mkdirs();
        File publicFolder = new File(baseDir, "public");
        publicFolder.mkdirs();
    }

    private void createFile(String templateName, HashMap<String, Object> data, File destFolder, String destFile) throws Exception {
        FileWriter contractCallAbiWriter = new FileWriter(new File(destFolder, destFile));
        this.generateFromTemplate(templateName, data, contractCallAbiWriter);
    }

    @Override
    protected boolean isPackageFolderCreationRequired() {
        return false;
    }
}

