/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="get-logs", aggregator=true)
public class AVMGetLogsMojo
extends AVMBaseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isLocal()) {
            throw new MojoExecutionException("aion4j:get-logs is only supported for remote Aion kernel");
        }
        String web3RpcUrl = this.resolveWeb3rpcUrl();
        String fromBlock = System.getProperty("fromBlock");
        String toBlock = System.getProperty("toBlock");
        String address = System.getProperty("address");
        String topics = System.getProperty("topics");
        String blockHash = System.getProperty("blockhash");
        RemoteAVMNode remoteAVMNode = new RemoteAVMNode(web3RpcUrl, (Log)MavenLog.getLog(this.getLog()));
        String logs = remoteAVMNode.getLogs(fromBlock, toBlock, address, topics, blockHash);
        if (logs == null) {
            this.getLog().info((CharSequence)"getlogs() failed");
            throw new MojoExecutionException("getlogs() failed");
        }
        this.getLog().info((CharSequence)("Logs: \n" + logs));
    }

    private void printHelp() {
        this.getLog().error((CharSequence)"Usage:");
        this.getLog().error((CharSequence)"mvn aion4j:get-logs -Dweb3rpc.url=http://host:port -DfromBlock=<block num> -DtoBlock=<block num> -Daddress=<address1, ...> -Dtopics=<topic1, ...> -Dblockhash=<block hash>");
    }
}

