/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.aion4j.avm.helper.exception.LocalAVMException;
import org.aion4j.maven.avm.mojo.AVMAbstractBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AVMLocalRuntimeBaseMojo
extends AVMAbstractBaseMojo {
    @Override
    protected Object getLocalAvmImplInstance(ClassLoader avmClassloader) {
        try {
            Class<?> clazz = avmClassloader.loadClass("org.aion4j.avm.helper.local.LocalAvmNode");
            Constructor<?> localAvmConstructor = clazz.getConstructor(String.class, String.class);
            String address = this.getLocalDefaultAddress();
            Object localAvmInstance = localAvmConstructor.newInstance(this.getStoragePath(), address);
            return localAvmInstance;
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Error creating LocalAvmNode instance", (Throwable)e);
            throw new LocalAVMException(e);
        }
    }

    @Override
    protected void postExecuteLocalAvm(Object localAvmInstance) throws MojoExecutionException {
        try {
            Method shutDownMethod = localAvmInstance.getClass().getMethod("shutdown", new Class[0]);
            if (localAvmInstance != null && shutDownMethod != null) {
                shutDownMethod.invoke(localAvmInstance, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().debug((CharSequence)"Error in postExecution", (Throwable)e);
        }
    }
}

