/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.io.File;
import java.io.IOException;
import org.aion4j.avm.helper.util.ZipUtil;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="prepack", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class AVMPrepackMojo
extends AVMBaseMojo {
    private static final String AVM_USERLIB_JAR = "org-aion-avm-userlib.jar";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.extractUserLibJarInClasses();
    }

    private void extractUserLibJarInClasses() throws MojoExecutionException {
        String libFolderPath = this.getAvmLibDir();
        File libFolder = new File(libFolderPath);
        if (!libFolder.exists()) {
            throw new MojoExecutionException(String.format("Precondition failed. Avm Lib folder not found.\n Please check if %s directory exist.\nYou may want to run 'mvn aion4j:initialize' to copy default avm jars to lib folder", libFolderPath));
        }
        File userLibJarFile = new File(libFolder, AVM_USERLIB_JAR);
        if (!userLibJarFile.exists()) {
            throw new MojoExecutionException(String.format("Precondition failed. Avm userlib jar file is not found in avm lib folder.\n Please check if %s directory exist.\nYou may want to try 'mvn aion4j:initialize' to copy default avm jars to lib folder", libFolderPath));
        }
        String outputDirectory = this.project.getBuild().getOutputDirectory();
        File classesFolder = new File(outputDirectory);
        try {
            this.getLog().info((CharSequence)String.format("Extracting  %s in classes folder for packaging", AVM_USERLIB_JAR));
            ZipUtil.unzipFile((File)userLibJarFile, (File)classesFolder);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to copy %s content to %s folder for packaging", AVM_USERLIB_JAR, outputDirectory), (Exception)e);
        }
    }
}

